% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_make_model.R
\name{mt_make_model}
\alias{mt_make_model}
\title{Function to train Deep Learning Classification model for Market Type recognition}
\usage{
mt_make_model(num_bars, path_model, path_data, f_name_data)
}
\arguments{
\item{num_bars}{Number of bars used to detect pattern}

\item{path_model}{Path where the models are be stored}

\item{path_data}{Path where the aggregated historical data is stored, if exists in rds format}

\item{f_name_data}{Name of the file with the data}
}
\value{
Function is writing file object with the model
}
\description{
Function is training h2o deep learning model to match manually classified patterns of the financial
indicator. Main idea is to be able to detect Market Type by solely relying on the current indicator pattern.
This is in the attempt to evaluate current market type and to use proper trading strategy.

Selected Market Periods according to the theory from Van K. Tharp:
1. Bull normal, BUN
2. Bull volatile, BUV
3. Bear normal, BEN
4. Bear volatile, BEV
5. Sideways quiet, RAN
6. Sideways volatile, RAV
}
\details{
Function is using manually prepared dataset
}
\examples{

\donttest{

library(dplyr)
library(readr)
library(h2o)
library(lazytrade)

path_model <- normalizePath(tempdir(),winslash = "/")
path_data <- normalizePath(tempdir(),winslash = "/")

data(macd_ML2_small)
write_rds(macd_ML2_small, file.path(path_data, 'macd_ML2_small.rds'))

# start h2o engine (using all CPU's by default)
h2o.init()


# performing Deep Learning Regression using the custom function
mt_make_model(num_bars = 128,
              path_model = path_model,
              path_data = path_data,
              f_name_data = "macd_ML2_small.rds")

# stop h2o engine
h2o.shutdown(prompt = FALSE)

#set delay to insure h2o unit closes properly before the next test
Sys.sleep(5)

}



}
\author{
(C) 2020 Vladimir Zhbanko
}
