% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aml_make_model.R
\name{aml_make_model}
\alias{aml_make_model}
\title{Function to train Deep Learning regression model for a single asset}
\usage{
aml_make_model(
  symbol,
  timeframe,
  path_model,
  path_data,
  force_update = FALSE,
  num_nn_options = 24,
  min_perf = 0.3
)
}
\arguments{
\item{symbol}{Character symbol of the asset for which to train the model}

\item{timeframe}{Data timeframe e.g. 1 min}

\item{path_model}{Path where the models shall be stored}

\item{path_data}{Path where the aggregated historical data is stored, if exists in rds format}

\item{force_update}{Boolean, by setting this to TRUE function will generate new model
(useful after h2o engine update)}

\item{num_nn_options}{Integer, value from 1 to 20 or more. Used to change number of variants
of the random neural network structures}

\item{min_perf}{Double, value greater than 0. Used to set minimum value of model performance.
Higher value will increase computation time}
}
\value{
Function is writing a file object with the best Deep Learning Regression model
}
\description{
Function is training h2o deep learning model to match future prices of the asset to the indicator pattern.
Main idea is to be able to predict future prices by solely relying on the recently retrieved indicator pattern.
This is to mimic traditional algorithmic systems based on the indicator rule attempting to automate optimization process with AI.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Deep learning model structure is obtained from the 8 random combinations of neurons within 3 hidden layers of the network,
the most accurate model configuration will be automatically selected

In addition, the function will check if there is a need to update the model. To do that function will check
results of the function aml_test_model.R.
}
\details{
Function is using the dataset prepared by the function aml_collect_data.R.
Function will start to train the model as soon as there are more than 1000 rows in the dataset
}
\examples{

\donttest{


library(dplyr)
library(readr)
library(h2o)
library(lazytrade)
library(lubridate)
library(magrittr)

path_model <- normalizePath(tempdir(),winslash = "/")
path_data <- normalizePath(tempdir(),winslash = "/")

ind = system.file("extdata", "AI_RSIADXUSDJPY60.csv",
                  package = "lazytrade") \%>\% read_csv(col_names = FALSE)

ind$X1 <- ymd_hms(ind$X1)


# data transformation using the custom function for one symbol
aml_collect_data(indicator_dataset = ind,
                 symbol = 'USDJPY',
                 timeframe = 60,
                 path_data = path_data)

# dataset will be written to the temp directory

# start h2o engine
h2o.init(nthreads = 2)


# performing Deep Learning Regression using the custom function
aml_make_model(symbol = 'USDJPY',
               timeframe = 60,
               path_model = path_model,
               path_data = path_data,
               force_update=FALSE,
               num_nn_options = 3,
               min_perf = 0)

# stop h2o engine
h2o.shutdown(prompt = FALSE)

#set delay to insure h2o unit closes properly before the next test
Sys.sleep(5)

}



}
\author{
(C) 2020 Vladimir Zhbanko
}
