% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/halting_tests.R
\name{create_halting_test}
\alias{create_halting_test}
\title{Creates halting test from multiple tests.}
\usage{
create_halting_test(halting_tests)
}
\arguments{
\item{halting_tests}{Either a vector of halting test functions
(or function names) with the signature
halting_test(condition, covariates, thresh)
(for the meaning of the parameters see
\code{\link{match_groups}}); or it may be a list of
list(test = halting_test, cond = subset_of_conditions,
     cov = variable_selector, thresh) fields.
All fields can be left out except test, and test need
not be named if it is the first item in the list.
The subset_of_conditions can be names of the
conditions to match (a character vector or a factor).
The variable_selector can be a logical vector with as
many items as there will be columns in covariates
(recommended), or a vector of integer covariate
column indices.
Each halting_test is then only applied to the
specified subset of conditions and variables of the
covariate matrix, with the specified threshold; when
a value is not specified the defaults are used.
Note that ordering the functions does not change the
behavior, but can make the execution of the combined
function faster, as the later ones are often evaluated
only if the criteria for the earlier ones is met.}
}
\value{
A function that returns the minimum of all halting test values;
        the threshold value supplied to it is recycled for the individual
        functions.
}
\description{
The created halting test function returns the smallest p-value-to-threshold
ratio of the values produced by the supplied tests, or zero if any of the
p-values does not exceed the threshold. The resulting function expects one
threshold per halting test in a vector or it recycles the given value(s) to
get a threshold for each one.
}

