% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{lai}
\alias{lai}
\title{calculates the lead area index (LAI)}
\usage{
lai(lad_profile, min = 1, max = 100)
}
\arguments{
\item{lad_profile}{output of the lad.profile function}

\item{min}{mix canopy height}

\item{max}{max canopy height}
}
\description{
calculates the lead area index (LAI)
}
\note{
The use of min and max arguments allowed the estimation of the LAI for different vertical strata
}
\examples{
# Get the example laz file
normlas.file = system.file("extdata", "lidar_example.laz", package="leafR")

# Calculate LAD from voxelization
VOXELS_LAD = lad.voxels(normlas.file,
                        grain.size = 2)

# Calculate the LAD profile
lad_profile = lad.profile(VOXELS_LAD)

lidar.lai = lai(lad_profile); lidar.lai
understory.lai = lai(lad_profile, min = 1, max = 5); understory.lai

# relative LAD PROFILE
relative.lad_profile = lad.profile(VOXELS_LAD, relative = TRUE)

#understory relative LAI (\% of total LAI)
relative.understory.lai = lai(relative.lad_profile, min = 1, max = 5); relative.understory.lai

}
