% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeslider.R
\name{addTimeslider}
\alias{addTimeslider}
\title{Add Time Slider to Leaflet}
\usage{
addTimeslider(map, data, options = timesliderOptions())
}
\arguments{
\item{map}{a map widget}

\item{data}{data must be a POINT Simple Feature with a time column.}

\item{options}{List of additional options. See \code{\link{timesliderOptions}}}
}
\value{
the new \code{map} object
}
\description{
The \href{https://github.com/dwilhelm89/LeafletSlider}{LeafletSlider plugin}
enables you to dynamically add and remove Markers on a map by using a
JQuery UI slider.
}
\examples{
\dontrun{
library(leaflet)
library(leaflet.extras2)
library(sf)
library(geojsonsf)

data <- sf::st_as_sf(leaflet::atlStorms2005[1,])
data <- st_cast(data, "POINT")
data$time = as.POSIXct(
  seq.POSIXt(Sys.time() - 1000, Sys.time(), length.out = nrow(data)))

leaflet() \%>\%
  addTiles() \%>\%
  addTimeslider(data = data,
             options = timesliderOptions(
               position = "topright",
               timeAttribute = "time",
               range = TRUE)) \%>\%
  setView(-72, 22, 4)
}
}
\references{
\url{https://github.com/dwilhelm89/LeafletSlider}
}
\seealso{
Other Timeslider Functions: 
\code{\link{removeTimeslider}()},
\code{\link{timesliderOptions}()}
}
\concept{Timeslider Functions}
