% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyprint.R
\name{easyprintOptions}
\alias{easyprintOptions}
\title{easyprintOptions}
\usage{
easyprintOptions(
  title = "Print map",
  position = "topleft",
  sizeModes = list("A4Portrait", "A4Landscape", "CurrentSize"),
  defaultSizeTitles = NULL,
  exportOnly = FALSE,
  tileLayer = NULL,
  tileWait = 500,
  filename = "map",
  hidden = FALSE,
  hideControlContainer = TRUE,
  hideClasses = NULL,
  customWindowTitle = NULL,
  spinnerBgColor = "#0DC5C1",
  customSpinnerClass = "epLoader"
)
}
\arguments{
\item{title}{Sets the text which appears as the tooltip of the print/export button}

\item{position}{Positions the print button}

\item{sizeModes}{Either a character vector with one of the following options:
\code{CurrentSize}, \code{A4Portrait}, \code{A4Landscape}. If you want to
include a \code{Custom} size mode you need to pass a named list, with
\code{width}, \code{height}, \code{name} and \code{className} and assign a
background-image in CSS.
See the example in \code{./inst/examples/easyprint_app.R}.}

\item{defaultSizeTitles}{Button tooltips for the default page sizes}

\item{exportOnly}{If set to \code{TRUE} the map is exported to a .png file}

\item{tileLayer}{The group name of one tile layer that you can wait for to draw
(helpful when resizing)}

\item{tileWait}{How long to wait for the tiles to draw (helpful when resizing)}

\item{filename}{Name of the file if \code{exportOnly} option is \code{TRUE}}

\item{hidden}{Set to \code{TRUE} if you don't want to display the toolbar.
Instead you can create your own buttons or fire print events programmatically.}

\item{hideControlContainer}{Hides the leaflet controls like the zoom buttons
and the attribution on the print out}

\item{hideClasses}{Use a character vector or list of CSS-classes to hide on
the output image.}

\item{customWindowTitle}{A title for the print window which will get
added to the printed paper}

\item{spinnerBgColor}{A valid css colour for the spinner background color}

\item{customSpinnerClass}{A class for a custom css spinner to use while
waiting for the print.}
}
\value{
A list of options for the 'easyprint' control
}
\description{
Create a list of further options for the easyprint plugin.
}
\references{
\url{https://github.com/rowanwins/leaflet-easyPrint}
}
\seealso{
Other EasyPrint Functions: 
\code{\link{addEasyprint}()},
\code{\link{easyprintMap}()},
\code{\link{removeEasyprint}()}
}
\concept{EasyPrint Functions}
