% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_block_summary}
\alias{plot_block_summary}
\title{Block Summary Plot}
\usage{
plot_block_summary(t, m, n, r)
}
\arguments{
\item{t}{time (or cost) required for the mth unit of production}

\item{m}{mth unit for which you have time (or cost) information (default is m = 1)}

\item{n}{nth (last) unit of production in the production block of concern (n > m)}

\item{r}{learning curve rate}
}
\description{
Plots the Crawford unit learning curve for the production block containing units m through n (inclusive) while highlighting midpoint values.
}
\examples{

# A production block runs from unit 201 to unit 500 inclusive.
# The 201st unit had a required time of 125 hours with a 75\% 
# learning curve. Plot the block summary?

plot_block_summary(t = 125, m = 201, n = 500, r = .75)
}

