% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{repvalue3.list}
\alias{repvalue3.list}
\title{Estimate Reproductive Value Vector for a List of Projection Matrices}
\usage{
\method{repvalue3}{list}(
  mats,
  stochastic = FALSE,
  times = 10000,
  tweights = NA,
  seed = NA,
  force_sparse = "auto",
  ...
)
}
\arguments{
\item{mats}{A list of population projection matrices, all in either class
\code{matrix} or class \code{dgCMatrix}.}

\item{stochastic}{A logical value indicating whether to use deterministic
(\code{FALSE}) or stochastic (\code{TRUE}) analysis. Defaults to
\code{FALSE}.}

\item{times}{An integer variable indicating number of occasions to project if
using stochastic analysis. Defaults to 10000.}

\item{tweights}{An optional numeric vector or matrix denoting the
probabilities of choosing each matrix in a stochastic projection. If a matrix
is input, then a first-order Markovian environment is assumed, in which the
probability of choosing a specific annual matrix depends on which annual
matrix is currently chosen. If a vector is input, then the choice of annual
matrix is assumed to be independent of the current matrix. Defaults to equal
weighting among matrices.}

\item{seed}{A number to use as a random number seed in stochastic projection.}

\item{force_sparse}{A text string indicating whether to use sparse matrix
encoding (\code{"yes"}) when supplied with standard matrices. Defaults to
\code{"auto"}, in which case sparse matrix encoding is used with square
matrices with at least 50 rows and no more than 50\% of elements with values
greater than zero.}

\item{...}{Other parameters.}
}
\value{
This function returns a list of vector data frames characterizing the 
reproductive values for stages of each population projection matrix. This is 
given as the left eigenvector associated with largest real part of the
dominant eigenvalue, divided by the first non-zero element of the left 
eigenvector.
}
\description{
\code{repvalue3.list()} returns the reproductive values for stages in
population projection matrices arranged in a general list. The function makes
no assumptions about whether the matrix is ahistorical and simply provides
standard reproductive values corresponding to each row, meaning that the
overall reproductive values of basic life history stages in a historical
matrix are not provided (the \code{\link{repvalue3.lefkoMat}()} function
estimates these on the basis of stage description information provided in the
\code{lefkoMat} object used as input in that function). This function can
handle large and sparse matrices, and so can be used with large historical
matrices, IPMs, age x stage matrices, as well as smaller ahistorical
matrices.
}
\section{Notes}{

Speed can sometimes be increased by shifting from automatic sparse matrix
determination to forced dense or sparse matrix projection. This will most
likely occur when matrices have several hundred rows and columns. Defaults
work best when matrices are very small and dense, or very large and sparse.
}

\examples{
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
  stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
  eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
  type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ")

repvalue3(ehrlen3$A)

}
\seealso{
\code{\link{repvalue3}()}

\code{\link{repvalue3.lefkoMat}()}

\code{\link{repvalue3.dgCMatrix}()}

\code{\link{repvalue3.matrix}()}
}
