% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gizmo-histogram.R
\name{gizmo_histogram}
\alias{gizmo_histogram}
\title{Guide gizmo: histogram}
\usage{
gizmo_histogram(
  key = "sequence",
  hist = NULL,
  hist.args = list(),
  hist.fun = graphics::hist,
  just = 1,
  oob = oob_keep,
  alpha = NA,
  theme = NULL,
  position = waiver(),
  direction = NULL
)
}
\arguments{
\item{key}{A \link[=key_sequence]{sequence key} or \link[=key_bins]{binned key}
specification.}

\item{hist}{One of the following:
\itemize{
\item \code{NULL} for computing histograms on the data values (default).
\item an atomic \verb{<vector>} to feed to the \code{hist.fun} function.
\item A named \verb{<list>} with \code{breaks} and \code{counts} numeric items, where the
\code{breaks} item is exactly one element longer than the \code{counts} item. A
typical way to construct such list is using the \code{\link[graphics:hist]{hist()}}
function. Please note that \verb{<list>} input is expected in scale-transformed
space, not original data space.
}}

\item{hist.args}{A \verb{<list>} with additional arguments to the \code{hist.fun}
argument. Only applies when \code{hist} is not provided as a \verb{<list>} already.}

\item{hist.fun}{A \verb{<function>} to use for computing histograms when the
\code{hist} argument is not provided as a list already.}

\item{just}{A \verb{<numeric[1]>} between 0 and 1. Use 0 for bottom- or
left-aligned histograms, use 1 for top- or right-aligned histograms and 0.5
for centred histograms.}

\item{oob}{An out-of-bounds handling function that affects the cap colour.
Can be one of the following:
\itemize{
\item A \verb{<function>} like \code{\link[scales:oob]{oob_squish}}.
\item A \verb{<character[1]>} naming such a function without the '\code{oob}'-prefix,
such as \code{"keep"}.
}}

\item{alpha}{A \verb{<numeric[1]>} between 0 and 1 setting the colour transparency
of the bar. Use \code{NA} to preserve the alpha encoded in the colour itself.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}

\item{direction}{A \verb{<character[1]>} indicating the direction of the guide. Can be on of
\code{"horizontal"} or \code{"vertical"}.}
}
\value{
A \verb{<GizmoHistogram>} object.
}
\description{
This guide displays a histogram of the aesthetic. If the aesthetic is
\code{colour} or \code{fill}, the shape will reflect this.
}
\details{
Non-finite values such as \code{NA} and \code{NaN} are ignored while infinite values
such as \code{-Inf} and \code{Inf} are \link[scales:oob]{squished} to the limits.
}
\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy, colour = cty)) +
  geom_point() +
  scale_colour_viridis_c()

# Histogram from plot data
p + guides(colour = gizmo_histogram())

# Using bins instead of gradient
p + guides(colour = gizmo_histogram("bins"))

# Providing custom values to compute histogram
p + guides(colour = gizmo_histogram(hist = runif(1000, min = 5, max = 35)))

# Providing precomputed histogram
p + guides(colour = gizmo_histogram(hist = hist(mpg$cty, breaks = 10)))

# Alternatively, parameters may be passed through hist.args
p + guides(colour = gizmo_histogram(hist.arg = list(breaks = 10)))
}
\seealso{
Other gizmos: 
\code{\link{gizmo_barcap}()},
\code{\link{gizmo_density}()},
\code{\link{gizmo_grob}()},
\code{\link{gizmo_stepcap}()}
}
\concept{gizmos}
