% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.frbe.R
\name{is.frbe}
\alias{is.frbe}
\title{Test whether \code{x} is a valid object of the S3 \code{frbe} class}
\usage{
is.frbe(x)
}
\arguments{
\item{x}{An object being tested.}
}
\value{
\code{TRUE} if \code{x} is a valid \code{frbe} object and \code{FALSE} otherwise.
}
\description{
Test whether \code{x} has a valid format for the objects of the S3 \code{frbe} class.
}
\details{
This function tests whether \code{x} inherits from \code{frbe} i.e. whether
it is a list with the following elements: \code{forecasts} data frame,
\code{features} data frame, \code{weights} vector, and \code{mean} vector.
Instances of the S3 class \code{frbe} are usually created by the \code{\link[=frbe]{frbe()}} function.
}
\references{
Štěpnička, M., Burda, M., Štěpničková, L. Fuzzy Rule Base
Ensemble Generated from Data by Linguistic Associations Mining. FUZZY SET
SYST. 2015.
}
\seealso{
\code{\link[=frbe]{frbe()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
