% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogEvent.R
\name{LogEvent}
\alias{LogEvent}
\alias{LogEvents}
\title{Events - The Atomic Unit of Logging}
\description{
A \code{LogEvent} is a single unit of data that should be logged. \code{LogEvents} are
usually created by a \link{Logger}, and then processed by \link{Appenders}.
}
\section{Usage}{
\preformatted{
x <- LogEvent$new(logger, level = 400, timestamp = Sys.time(), caller = NA, msg
  = NA, ...)

x$clone(deep = FALSE)

x$.logger
x$caller
x$level
x$level_name
x$logger
x$msg
x$timestamp
x$values

}
}

\section{Creating LogEvents / Fields}{


The arguments to \code{LogEvent$new()} directly translate to the fields stored in
the LogEvent:

\describe{
\item{\code{level}}{\code{integer}: the \link{log_level} / priority of the LogEvent}

\item{\code{timestamp}}{\code{\link[base:POSIXct]{POSIXct}} the time when then the
LogEvent was created}

\item{\code{caller}}{\code{character}. The name of the calling function}

\item{\code{msg}}{\code{character}. A message}

\item{\code{logger}}{\code{character} scalar. Name of the Logger that created the
event (\code{.logger$full_name})
}

\item{\code{user}}{\code{character} scalar. User as set for the Logger
that created this event (\code{.logger$user})
}

\item{\code{.logger}}{a \code{Logger}. A reference to the Logger that created the
event
}

\item{\code{...}}{All named arguments in \code{...} will be added to the LogEvent
as \strong{custom fields}. You can store arbitrary \R objects in LogEvents
this way, but not all Appenders will support them.
See \link{AppenderJson} for
an Appender that supports custom fields quite naturally.}
}

Usually the above values will be scalars, but (except for \code{"logger"}) they
can also be vectors if they are all of the same length (or scalars that will
be recycled). In this case the event will be treated by the \link{Appenders} and
\link{Layouts} as if several separate events.
}

\section{Active Bindings}{


LogEvents contain some some active bindings that make it easier to retrieve
commonly used values.

\describe{
\item{\code{level_name}}{\code{character}: the \link{log_level} / priority of the
LogEvent labelled according to \code{getOption("lgr.log_levels")}}
\item{\code{values}}{\code{list}: All values stored in the LogEvent (including
all \emph{custom fields}, but not including \code{event$logger})}
\item{\code{logger_name}}{\code{character} scalar: The name of the Logger that
created this event, equivalent to \code{event$logger$name})}
\item{\code{logger_user}}{\code{character} scalar: The user of the Logger that
created this event, equivalent to \code{event$logger_user})}
}
}

\examples{
l <- Logger$new("dummy logger", appenders = NULL)
l$error("foo bar")

# The last LogEvent produced by a Logger is stored in the last_event field
l$last_event  # formatted by default
l$last_event$values  # values stored in the event

# Also contains the Logger that created it as .logger
l$last_event$logger
# equivalent to
l$last_event$.logger$name

# This is really a reference to the complete Logger, so the following is
# possible (though nonsensical)
l$last_event$.logger$last_event$msg
identical(l, l$last_event$.logger)

}
\seealso{
\code{\link[=as.data.frame.LogEvent]{as.data.frame.LogEvent()}}
}
