% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibcodes.R
\name{check_issn_check_digit}
\alias{check_issn_check_digit}
\title{Check the check digit of an ISSN}
\usage{
check_issn_check_digit(x, allow.hyphens = TRUE, errors.as.false = FALSE)
}
\arguments{
\item{x}{A string of 8 digits or 7 digits with terminal "X"}

\item{allow.hyphens}{A logical indicating whether the hyphen
separator should be allowed}

\item{errors.as.false}{return false if error instead of throwing error}
}
\value{
Returns TRUE if check passes, FALSE if not, and NA if NA
}
\description{
Takes a string representation of an ISSN and verifies that check digit
checks out
}
\examples{

check_issn_check_digit("2434561X")   # TRUE
check_issn_check_digit("2434-561X")  # TRUE

# vectorized
check_issn_check_digit(c("03785955", "2434561X", NA))  # TRUE TRUE NA
check_issn_check_digit(c("0378-5955", "2434-561X", NA))
# TRUE TRUE NA

}
