% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split-map-filter-reduce.R
\name{recombine_with_sep_closure}
\alias{recombine_with_sep_closure}
\title{Return a function that will combine/contatenate a vector}
\usage{
recombine_with_sep_closure(sep = ";")
}
\arguments{
\item{sep}{A character to use in between the elements
(default is a semicolon character)}
}
\value{
Returns a closure/function
}
\description{
This function takes and optional separator, and returns
a function that takes a vector and \code{paste}s the
elements of that vector together
}
\details{
Can be used as a reduction function in \code{split_map_filter_reduce}
}
\examples{

lambda <- recombine_with_sep_closure()
lambda(c(8, 6, 7))                               # "8;6;7"

# directly
recombine_with_sep_closure()(c(8,6,7))           #  "8;6;7"
lambda <- recombine_with_sep_closure(" ")
lambda(c("this", "that", NA,"the-other"))        # "this that NA the-other"

}
\seealso{
\code{\link{split_map_filter_reduce}}

\code{\link{paste}}
}
