% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_eq_build.R
\name{ls_eq_build}
\alias{ls_eq_build}
\alias{ls_eq_is}
\alias{ls_eq_if}
\alias{ls_eq_brace}
\alias{ls_eq_quote}
\alias{ls_eq_isChecked}
\alias{ls_eq_isUnchecked}
\alias{ls_eq_ifRegex}
\title{Building LimeSurvey Expression Manager equations}
\usage{
ls_eq_build(lhs, operator, rhs)

ls_eq_is(varCode, value, naok = TRUE)

ls_eq_isChecked(varCode, naok = TRUE)

ls_eq_isUnchecked(varCode, naok = TRUE)

ls_eq_if(cond, ifExpr, elseExpr)

ls_eq_ifRegex(regex, varCode, ifExpr, elseExpr, naok = TRUE)

ls_eq_brace(expr)

ls_eq_quote(expr)
}
\arguments{
\item{lhs}{The left-hand side expression.}

\item{operator}{The operator.}

\item{rhs}{The right-hand side expression.}

\item{varCode}{A LimeSurvey variable code.}

\item{value}{A value.}

\item{naok}{Whether to append ".NAOK" to the variable code.}

\item{cond}{A condition, for example created by \code{ls_eq_build()}
or \code{ls_eq_is()}.}

\item{ifExpr, elseExpr, expr}{An expression.}

\item{regex}{A regular expression.}
}
\value{
A character vector.
}
\description{
These are a set of really basic functions that facilitate
building LimeSurvey Expression Manager (LSEM) equations.
}
\details{
\code{ls_eq_build()} just pastes together its three
arguments in the same order using a space as
separator. So it's mostly used for clarity when
building LSEM equations.

\code{ls_eq_is()} uses \code{ls_eq_build()} to specify a logical
expression that is true when \code{varCode} equals \code{value}.

\code{ls_eq_if()} builds an if/then/else expression; if
\code{cond} evaluates to TRUE, the LSEM uses \code{ifExpr};
otherwise, it uses \code{elseExpr}.

\code{ls_eq_ifRegex} checks a question against a regular expression.

\code{ls_eq_isChecked()} and \code{ls_eq_isUnchecked()} return an
expression evaluating whether a checkbox is checked (or not).

\code{ls_eq_brace()} simply embraces \code{expr}, an expression
(i.e. it prepends \verb{\{} and appends \verb{\}}).

\code{ls_eq_quote()} simply embraces \code{expr}, an expression
(i.e. it prepends \verb{'} and appends \verb{'}).
}
\examples{
ls_eq_build("questionCode", "==", "Y");

}
