% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkSAGA.R
\name{linkSAGA}
\alias{linkSAGA}
\title{Locate and bind valid SAGA installation(s)}
\usage{
linkSAGA(default_SAGA = NULL, DL = "C:", MP = "/usr",
  ver_select = FALSE)
}
\arguments{
\item{default_SAGA}{string contains path to SAGA binaries}

\item{DL}{drive letter}

\item{MP}{mount point}

\item{ver_select}{boolean default is FALSE. If there is more than one 'SAGA GIS' installation and \code{ver_select} = TRUE the user can select interactively the preferred 'SAGA GIS' version}
}
\description{
Locate and bind valid \href{http://www.saga-gis.org/}{SAGA}
 installation(s). It returns the pathes and correct environment settings. All
 valid means that it looks for the \code{saga_cmd} or \code{saga_cmd.exe}
 executables. If the file is found it is assumed to be a valid 'SAGA GIS' installation.
}
\details{
If called without any parameter \code{linkSAGA()} it performs a full search over \code{C:}. If it finds one or more 'SAGA GIS' binaries it will take the first hit. You have to set \code{ver_select = TRUE} for an interactive selection of the preferred version. Additionally the selected SAGA pathes are added to the environment and the global variables \code{sagaPath}, \code{sagaModPath} and \code{sagaCmd} will be created.
}
\note{
The excellent 'SAGA GIS' wrapper \href{https://CRAN.R-project.org/package=RSAGA}{RSAGA} is NOT used because the
 it currently covers only 'SAGA GIS' versions from 2.0.4 - 2.2.3. The fast SAGA GIS changes makes it highly impracticable
 to keep the wrapper adaptions in line. \code{RSAGA} will meet all linking needs perfectly if you use 'SAGA GIS' versions from 2.0.4 - 2.2.3.
}
\examples{
\dontrun{

# call if you do not have any idea if and where SAGA GIS is installed
linkSAGA()

# typical OSGeo4W64 installation 
linkSAGA(c("C:/OSGeo4W64/apps/saga","C:/OSGeo4W64/apps/saga/modules"))
}
}
