% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim.R
\name{set_dim}
\alias{set_dim}
\title{Reshape an array}
\usage{
set_dim(
  x,
  new_dim,
  pad = getOption("listarrays.autopad_arrays_with", NULL),
  order = c("F", "C"),
  verbose = getOption("verbose")
)
}
\arguments{
\item{x}{A vector or array to set dimensions on}

\item{new_dim}{The desired dimensions (an integer(ish) vector)}

\item{pad}{The value to pad the vector with. \code{NULL} (the default) performs no
padding.}

\item{order}{whether to use row-major (C) or column major (F) style
semantics. The default, "F", corresponds to the default behavior of R's
\verb{dim<-()}, while "C" corresponds to the default behavior of
\code{reticulate::array_reshape()}, numpy, reshaping semantics commonly
encountered in the python world.}

\item{verbose}{Whether to emit a message if padding. By default, \code{FALSE}.}
}
\value{
Object with dimensions set
}
\description{
Pipe friendly \verb{dim<-()}, with option to pad to necessary length. Also allows
for filling the array using C style row-major semantics.
}
\examples{
set_dim(1:10, c(2, 5))
try( set_dim(1:7, c(2, 5)) ) # error by default, just like `dim<-`()
     set_dim(1:7, c(2, 5), pad = 99)
     set_dim(1:7, c(2, 5), pad = 99, order = "C") # fills row-wise

y <- x <- 1:4
# base::dim<- fills the array column wise
dim(x) <- c(2, 2)
x

# dim2 will fill the array row-wise
dim2(y) <- c(2, 2)
y

identical(x, set_dim(1:4, c(2,2)))
identical(y, set_dim(1:4, c(2,2), order = "C"))

\dontrun{
py_reshaped <- reticulate::array_reshape(1:4, c(2,2))
storage.mode(py_reshaped) <- "integer" # reticulate coerces to double
identical(y, py_reshaped)
# if needed, see listarrays:::array_reshape() for
# a drop-in pure R replacement for reticulate::array_reshape()
}
}
\seealso{
\code{set_dim2()}, \code{`dim<-`()}, \code{reticulate::array_reshape()}
}
