% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_code.R
\name{add_predictions}
\alias{add_predictions}
\title{Add black box predictions to generated dataset}
\usage{
add_predictions(data, to_explain, black_box_model, predict_fun = predict,
  hyperparams = list(), ...)
}
\arguments{
\item{data}{Original data frame used to generate new dataset.}

\item{to_explain}{List return by sample_locally function.}

\item{black_box_model}{String with mlr signature of a learner or a model with predict interface.}

\item{predict_fun}{Either a "predict" function that returns a vector of the
same type as response or custom function that takes a model as a first argument,
and data used to calculate predictions as a second argument
and returns a vector of the same type as respone.
Will be used only if a model object was provided in the black_box argument.}

\item{hyperparams}{Optional list of (hyper)parameters to be passed to mlr::makeLearner.}

\item{...}{Additional parameters to be passed to predict function.}
}
\value{
list containing simulated dataset with added predictions,
             name of a response variable and black box model object.
}
\description{
DEPRECATED. Please refer to add_predictions2 function for updated and improved interface.
This function will be removed in the next version of the package and was left only
to remain consistent with the examples given in https://arxiv.org/abs/1804.01955.
For more, see NEWS and vignette.
}
\examples{
\dontrun{
local_exploration1 <- add_predictions(wine, dataset_for_local_exploration,
                                      black_box_model = "regr.svm")
# Pass trained model to the function.
svm_model <- svm(quality ~., data = wine)
local_exploration2 <- add_predictions(wkne, dataset_for_local_exploration,
                                      black_box_model = svm_model)
}

}
