% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint.lmeresamp}
\alias{confint.lmeresamp}
\title{Calculate confidence intervals for a lmeresamp object}
\usage{
\method{confint}{lmeresamp}(
  object,
  parm,
  level = 0.95,
  type = c("all", "norm", "basic", "perc"),
  ...
)
}
\arguments{
\item{object}{The lmeresamp object for which confidence intervals should be computed.}

\item{parm}{not used}

\item{level}{The level at which the confidence interval should be calculated.}

\item{type}{A character string giving the type of confidence intervals that should be calculated. 
This should be a subset of \code{c("norm", "basic", "perc")} (for normal, basic, and percentile
bootstrap confidence intervals, respectively), or \code{"all"}.}

\item{...}{not used}
}
\value{
A tibble with columns term, estimate, lower, upper, type, and level.
}
\description{
Calculates normal, basic, and percentile bootstrap confidence intervals 
from a \code{lmeresamp} object.
}
