% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_hierarchical_lm.R
\name{print.hierarchical_lm}
\alias{print.hierarchical_lm}
\title{Print a \code{hierarchial_lm} Class Object}
\usage{
\method{print}{hierarchical_lm}(
  x,
  digits = 4,
  signif.stars = getOption("show.signif.stars"),
  eps.Pvalue = 0.001,
  ...
)
}
\arguments{
\item{x}{A \code{hierarchical_lm}-class
object, usually the output of
\code{hierarchical_lm()}.}

\item{digits}{The minimum number of
significant digits to be used for
most numbers. To be used by the print
method of \code{anova}-class objects.}

\item{signif.stars}{Logical. To be
used by the print method of
\code{anova}-class objects.}

\item{eps.Pvalue}{To be passed to
\code{format.pval()}. It controls how
small \emph{p}-values are displayed.
Default is \code{.001}. That is,
\emph{p}-values less than \code{.001} will be
displayed as \verb{<.001}.}

\item{...}{Optional arguments. To
be passed to the print method of
\code{anova}-class objects.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of
a 'hierarchical_lm`-class object.
}
\details{
The printout is very similar
to that of the print method of
an \code{anova} object. It simply
overrides the default values for
some arguments, notably \code{esp.Pvalue}
to prevent small \emph{p}-values to be
presented in scientific notation.
}
\examples{

dat <- data_test1
lm1 <- lm(y ~ x1 + x2, dat)
lm2 <- lm(y ~ x1 + x2 + x3 + x4, dat)
lm3 <- lm(y ~ x1 + cat1 + cat2 + x2 + x3 + x4, dat)
lm4 <- lm(y ~ x1 + x2*x3 + x4, dat)

hierarchical_lm(lm1, lm3, lm2)
hierarchical_lm(lm1, lm2, lm4)

}
\seealso{
\code{\link[=hierarchical_lm]{hierarchical_lm()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
