% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excursion.R
\name{proba_theoretical_ith_excursion_iid}
\alias{proba_theoretical_ith_excursion_iid}
\title{Probability \eqn{P(Q(i)\geq a)} that the height of the ith excursion (sequential order) is greater or equal to \code{a} given a i.i.d. model on the letters sequence}
\usage{
proba_theoretical_ith_excursion_iid(
  a,
  theta,
  theta_distribution,
  score_function,
  i = 1
)
}
\arguments{
\item{a}{score strictly positive}

\item{theta}{vector containing the alphabet used}

\item{theta_distribution}{distribution vector of theta}

\item{score_function}{vector containing the scores of each letters of the alphabet (must be in the same order as theta)}

\item{i}{Number of excursion in sequential order}
}
\value{
theoretical probability of reaching a score of a on the ith excursion supposing an  i.i.d model on the letters sequence
}
\description{
Mathematical definition of an excursion of the Lindley process is based on the record times of the partial
sum sequence associated to the score sequence (see Karlin and Altschul 1990, Karlin and Dembo 1992) and
define the successive times where the partial sums are strictly decreasing. There must be distinguished
from the visual excursions of the Lindley sequence. The number \code{i} is the number of excursion in sequential order. Detailed definitions are given in the vignette.
}
\details{
In the i.i.d., the distribution of the ith excursion is the same as the first excursion. This function is just for convenience, and the result is the same as \code{proba_theoretical_first_excursion_iid}. Beware that a sequence beginning with a negative score gives a "flat" excursion, with score 0 are considered.
}
\examples{
p1 <- proba_theoretical_ith_excursion_iid(3, c("a","b","c","d"), 
                                      c(a=0.1,b=0.2,c=0.4,d=0.3), c(a=-3,b=-1,c=1,d=2), i = 10)
p2 <- proba_theoretical_first_excursion_iid(3, c("a","b","c","d"), 
                                      c(a=0.1,b=0.2,c=0.4,d=0.3), c(a=-3,b=-1,c=1,d=2))
p1 == p2  #TRUE
}
\seealso{
\code{\link{proba_theoretical_first_excursion_iid}}
}
