% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locus_plot.R
\name{locus_plot}
\alias{locus_plot}
\title{Locus plot}
\usage{
locus_plot(
  loc,
  filter_gene_name = NULL,
  filter_gene_biotype = NULL,
  xlab = NULL,
  cex = 1,
  cex.axis = 0.9,
  cex.lab = 1,
  cex.text = 0.7,
  use_layout = TRUE,
  heights = c(3, 2),
  showExons = TRUE,
  maxrows = 7,
  xticks = "bottom",
  border = FALSE,
  gene_col = "blue4",
  exon_col = "blue4",
  exon_border = "blue4",
  text_pos = "top",
  ...
)
}
\arguments{
\item{loc}{Object of class 'locus' to use for plot. See \code{\link[=locus]{locus()}}.}

\item{filter_gene_name}{Vector of gene names to display.}

\item{filter_gene_biotype}{Vector of gene biotypes to be filtered. Use
\code{\link[ensembldb:EnsDb-class]{ensembldb::listGenebiotypes()}} to display possible biotypes. For example,
\code{ensembldb::listGenebiotypes(EnsDb.Hsapiens.v75)}}

\item{xlab}{x axis title.}

\item{cex}{Specifies size for points.}

\item{cex.axis}{Specifies font size for axis numbering.}

\item{cex.lab}{Specifies font size for axis titles.}

\item{cex.text}{Font size for gene text.}

\item{use_layout}{Logical whether \code{graphics::layout} is called. Default
\code{TRUE} is for a standard single plot. Set to \code{FALSE} if a more complex
layout with multiple plots is required e.g. using \code{\link[=multi_layout]{multi_layout()}}.}

\item{heights}{Ratio of top to bottom plot. See \link{layout}.}

\item{showExons}{Logical whether to show exons or simply show whole gene as a
rectangle}

\item{maxrows}{Specifies maximum number of rows to display in gene
annotation panel.}

\item{xticks}{Character value of either 'top' or 'bottom' specifying
whether x axis ticks and numbers are plotted on top or bottom plot window.}

\item{border}{Logical whether a bounding box is plotted around upper and
lower plots.}

\item{gene_col}{Colour for gene lines.}

\item{exon_col}{Fill colour for exons.}

\item{exon_border}{Border line colour outlining exons (or genes if
\code{showExons} is \code{FALSE}). Set to \code{NA} for no border.}

\item{text_pos}{Character value of either 'top' or 'left' specifying
placement of gene name labels.}

\item{...}{Other arguments passed to \code{\link[=scatter_plot]{scatter_plot()}} to control the scatter
plot.}
}
\value{
No return value.
}
\description{
Genomic locus plot similar to locuszoom.
}
\details{
This is an R version of locuszoom for generating publication ready Manhattan
plots of gene loci. It references Ensembl databases for annotating genes
and exons. Use \code{\link[=locus]{locus()}} first to generate an object of class 'locus' for
plotting. LDlink web server can be queried using function \code{\link[=link_LD]{link_LD()}} to
retrieve linkage disequilibrium (LD) information on the index SNP.
}
\examples{
if(require(EnsDb.Hsapiens.v75)) {
library(EnsDb.Hsapiens.v75)
data(SLE_gwas_sub)
loc <- locus(SLE_gwas_sub, gene = 'UBE2L3', flank = 1e5,
             ens_db = "EnsDb.Hsapiens.v75")
locus_plot(loc)

## Use embedded LD information in column `r2`
loc2 <- locus(SLE_gwas_sub, gene = 'IRF5', flank = c(7e4, 2e5), LD = "r2",
              ens_db = "EnsDb.Hsapiens.v75")
locus_plot(loc2)
}
}
\seealso{
\code{\link[=locus]{locus()}} \code{\link[=scatter_plot]{scatter_plot()}} \code{\link[=genetracks]{genetracks()}}
}
