% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backward.r
\name{backward}
\alias{backward}
\alias{backward.logistf}
\alias{backward.flic}
\alias{forward}
\alias{forward.logistf}
\title{Backward Elimination/Forward Selection of Model Terms in logistf Models}
\usage{
backward(object, ...)

\method{backward}{logistf}(
  object,
  scope,
  steps = 1000,
  slstay = 0.05,
  trace = TRUE,
  printwork = FALSE,
  full.penalty = FALSE,
  ...
)

\method{backward}{flic}(
  object,
  scope,
  steps = 1000,
  slstay = 0.05,
  trace = TRUE,
  printwork = FALSE,
  full.penalty = FALSE,
  ...
)

forward(object, ...)

\method{forward}{logistf}(
  object,
  scope,
  steps = 1000,
  slentry = 0.05,
  trace = TRUE,
  printwork = FALSE,
  pl = TRUE,
  ...
)
}
\arguments{
\item{object}{A fitted logistf model object. To start with an empty model, create a model fit
with a formula= y~1, pl=FALSE. (Replace y by your response variable.)}

\item{...}{Further arguments to be passed to methods.}

\item{scope}{The scope of variables to add/drop from the model. Can be missing for backward, backward will use
the terms of the object fit. Alternatively, an arbitrary vector of variable names can be given, to allow
that only some of the variables will be competitively selected or dropped. Has to be provided for forward.}

\item{steps}{The number of forward selection/backward elimination steps.}

\item{slstay}{For \code{backward}, the significance level to stay in the model.}

\item{trace}{If \code{TRUE}, protocols selection steps.}

\item{printwork}{If \code{TRUE}, prints each working model that is visited by the selection procedure.}

\item{full.penalty}{If \code{TRUE} penalty is not taken from current model but from start model.}

\item{slentry}{For \code{forward}, the significance level to enter the model.}

\item{pl}{For forward, computes profile likelihood confidence intervals for the final model if \code{TRUE}.}
}
\value{
An updated \code{logistf, flic} or \code{flac} fit with the finally selected model.
}
\description{
These functions provide simple backward elimination/forward selection procedures for logistf models.
}
\details{
The variable selection is simply performed by repeatedly calling add1 or drop1 methods for logistf,
and is based on penalized likelihood ratio test. It can also properly handle variables that were
defined as factors in the original data set.
}
\section{Functions}{
\itemize{
\item \code{forward()}: Forward Selection

}}
\examples{
data(sex2) 
fit<-logistf(data=sex2, case~1, pl=FALSE) 
fitf<-forward(fit, scope = c("dia", "age")) 

fit2<-logistf(data=sex2, case~age+oc+vic+vicl+vis+dia) 
fitb<-backward(fit2)

}
