% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{samp_elife}
\alias{samp_elife}
\title{Simulate excess lifetime with truncation or right-censoring}
\usage{
samp_elife(
  n,
  scale,
  rate,
  shape = NULL,
  lower = 0,
  upper = Inf,
  family = c("exp", "gp", "gomp", "gompmake", "weibull", "extgp", "gppiece",
    "extweibull", "perks", "beard", "perksmake", "beardmake"),
  type2 = c("none", "ltrt", "ltrc", "ditrunc")
)
}
\arguments{
\item{n}{sample size}

\item{scale}{scale parameter(s)}

\item{rate}{rate parameter(s)}

\item{shape}{shape parameter(s)}

\item{lower}{vector of lower bounds}

\item{upper}{vector of upper bounds}

\item{family}{string; choice of parametric family}

\item{type2}{string, either \code{none}, \code{ltrt} for left- and right-truncated data or \code{ltrc} for left-truncated right-censored data}
}
\value{
either a vector of observations or, if \code{type2=ltrc}, a list with \code{n} observations \code{dat} and a logical vector of the same length with \code{TRUE} for right-censored observations and \code{FALSE} otherwise.
}
\description{
This function dispatches simulations accounting for potential left-truncation (remove by setting lower to zero).
If \code{type2=ltrt}, simulated observations will be lower than the upper bounds \code{upper}.
If \code{type2=ltrc}, simulated observations are capped at \code{upper} and the observation is right-censored (\code{rcens=TRUE}).
}
\examples{
set.seed(1234)
n <- 500L
# Simulate interval truncated data
x <- samp_elife(n = n,
                scale = 2,
                shape = 1.5,
                lower = low <- runif(n),
                upper = upp <- runif(n, min = 3, max = 15),
                type2 = "ltrt",
                family = "weibull")
coef(fit_elife(
   time = x,
   ltrunc = low,
   rtrunc = upp,
   family = "weibull"))
# Simulate left-truncated right-censored data
x <- samp_elife(n = n,
                scale = 2,
                shape = 1.5,
                lower = low <- runif(n),
                upper = upp <- runif(n, min = 3, max = 15),
                type2 = "ltrc",
                family = "gomp")
#note that the return value is a list...
coef(fit_elife(
   time = x$dat,
   ltrunc = low,
   event = !x$rcens,
   family = "gomp"))
}
