% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpdensity_methods.R
\name{vcov.lpdensity}
\alias{vcov.lpdensity}
\title{Vcov Method for Local Polynomial Density Estimation and Inference}
\usage{
\method{vcov}{lpdensity}(object, ...)
}
\arguments{
\item{object}{Class "lpdensity" object, obtained by calling \code{\link{lpdensity}}.}

\item{...}{Additional options.}
}
\value{
\item{stdErr}{A matrix containing grid points and standard errors using p- and q-th order local polynomials.}
\item{CovMat_p}{The variance-covariance matrix corresponding to \code{f_p}.}
\item{CovMat_q}{The variance-covariance matrix corresponding to \code{f_q}.}
}
\description{
The vcov method for local polynomial density objects.
}
\examples{
# Generate a random sample
set.seed(42); X <- rnorm(2000)

# Estimate density and report results
vcov(lpdensity(data = X, bwselect = "imse-dpi"))

}
\seealso{
\code{\link{lpdensity}} for local polynomial density estimation.

Supported methods: \code{\link{coef.lpdensity}}, \code{\link{confint.lpdensity}},
  \code{\link{plot.lpdensity}}, \code{\link{print.lpdensity}}, \code{\link{summary.lpdensity}},
  \code{\link{vcov.lpdensity}}.
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Michael Jansson, University of California Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}.
}
