% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpdensity_methods.R
\name{confint.lpdensity}
\alias{confint.lpdensity}
\title{Confint Method for Local Polynomial Density Estimation and Inference}
\usage{
\method{confint}{lpdensity}(object, parm = NULL, level = NULL, ...)
}
\arguments{
\item{object}{Class "lpdensity" object, obtained by calling \code{\link{lpdensity}}.}

\item{parm}{Integer, indicating which parameters are to be given confidence intervals.}

\item{level}{Numeric scalar between 0 and 1, the significance level for computing confidence intervals}

\item{...}{Additional options, including (i) \code{grid} specifies a subset of grid points
to display the bandwidth; (ii) \code{gridIndex} specifies the indices of grid points
to display the bandwidth (this is the same as \code{parm}); (iii) \code{alpha} specifies the significance level
(this is \code{1-level}); (iv)
\code{CIuniform} specifies whether displaying pointwise confidence intervals (\code{FALSE}, default) or
the uniform confidence band (\code{TRUE}); (v) \code{CIsimul} specifies the number of simulations used
to construct critical values (default is 2000).}
}
\value{
\item{}{A matrix containing grid points and confidence interval end points using p- and q-th order local polynomials.}
}
\description{
The confint method for local polynomial density objects.
}
\examples{
# Generate a random sample
set.seed(42); X <- rnorm(2000)

# Estimate density and report 95\% confidence intervals
est1 <- lpdensity(data = X, bwselect = "imse-dpi")
confint(est1)

# Report results for a subset of grid points
confint(est1, parm=est1$Estimate[4:10, "grid"])
confint(est1, grid=est1$Estimate[4:10, "grid"])
confint(est1, gridIndex=4:10)

# Report the 99\% uniform confidence band
# Fix the seed for simulating critical values
set.seed(42); confint(est1, level=0.99, CIuniform=TRUE)
set.seed(42); confint(est1, alpha=0.01, CIuniform=TRUE)

}
\seealso{
\code{\link{lpdensity}} for local polynomial density estimation.

Supported methods: \code{\link{coef.lpdensity}}, \code{\link{confint.lpdensity}},
  \code{\link{plot.lpdensity}}, \code{\link{print.lpdensity}}, \code{\link{summary.lpdensity}},
  \code{\link{vcov.lpdensity}}.
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Michael Jansson, University of California Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}.
}
