% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_io_type.R
\name{detect_io_type}
\alias{detect_io_type}
\title{Detect the file type of an LPJmL input/output file}
\usage{
detect_io_type(filename)
}
\arguments{
\item{filename}{Character string naming the file to check.}
}
\value{
Character vector of length 1 giving the file type:
\itemize{
\item "cdf" for a NetCDF file (classic or NetCDF4/HDF5 format).
\item "clm" for a binary LPJmL input/output file with header.
\item "meta" for a JSON meta file describing a binary LPJmL input/output file.
\item "raw" for a binary LPJmL input/output file without header. This is also the
default if no other file type can be recognized.
\item "text" for any type of text-only file, e.g. ".txt" or ".csv"
}
}
\description{
This utility function tries to detect automatically if a
provided file is of \code{"clm"}, \code{"meta"}, or \code{"raw"} file type. NetCDFs and
simple text formats such as ".txt" or ".csv" are also detected.
}
\examples{
\dontrun{
detect_io_type(filename = "filename.clm")
# [1] "clm"
}

}
