% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_lpjml.R
\name{make_lpjml}
\alias{make_lpjml}
\title{Compile LPJmL model}
\usage{
make_lpjml(
  model_path = ".",
  parallel_cores = NULL,
  make_clean = FALSE,
  raise_error = TRUE,
  debug = NULL
)
}
\arguments{
\item{model_path}{Character string providing the path to LPJmL
(equal to \code{LPJROOT} environment variable). Defaults sto ".".}

\item{parallel_cores}{Numeric defining the number of available CPU cores for
parallelization.}

\item{make_clean}{Logical. If set to \code{TRUE}, calls "make clean" first to
remove previous installation. Defaults to \code{FALSE}.}

\item{raise_error}{Logical. Whether to raise an error if sub-process has
non-zero exit status, hence if compilation fails. Defaults to \code{TRUE}.}

\item{debug}{NULL or Logical. Whether to compile LPJmL with "-debug" flag.
Defaults to \code{NULL}. If set to \code{FALSE} or \code{TRUE}, \code{make_clean} is set
automatically and compilation configuration is reset with/without "-debug".
Also the "configure.sh" file is rewritten.}
}
\value{
A list with process status, see \link[processx]{run}.
}
\description{
Compiles the LPJmL source code and creates an executable by executing
"make all" on the operating system shell.
}
\examples{
\dontrun{
model_path <- "./LPJmL_internal"
make_lpjml(model_path = model_path)
}

}
