% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrsim2e}
\alias{lrsim2e}
\title{Log-rank test simulation for two endpoints and two arms}
\usage{
lrsim2e(
  kMax = NA_integer_,
  kMaxe1 = NA_integer_,
  hazardRatioH0e1 = 1,
  hazardRatioH0e2 = 1,
  allocation1 = 1L,
  allocation2 = 1L,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  rho = 0,
  lambda1e1 = NA_real_,
  lambda2e1 = NA_real_,
  lambda1e2 = NA_real_,
  lambda2e2 = NA_real_,
  gamma1e1 = 0L,
  gamma2e1 = 0L,
  gamma1e2 = 0L,
  gamma2e2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  rho1 = 0,
  rho2 = 0,
  plannedEvents = NA_integer_,
  plannedTime = NA_real_,
  maxNumberOfIterations = 1000L,
  maxNumberOfRawDatasetsPerStage = 0L,
  seed = NA_integer_
)
}
\arguments{
\item{kMax}{The maximum number of stages.}

\item{kMaxe1}{Number of stages with timing determined by PFS events. 
Ranges from 0 (none) to \code{kMax}.}

\item{hazardRatioH0e1}{Hazard ratio under the null hypothesis for the 
active treatment vs control for endpoint 1 (PFS). Defaults to 1 for 
superiority test.}

\item{hazardRatioH0e2}{Hazard ratio under the null hypothesis for the 
active treatment vs control for endpoint 2 (OS). Defaults to 1 for 
superiority test.}

\item{allocation1}{Number of subjects in the treatment group in
a randomization block. Defaults to 1 for equal randomization.}

\item{allocation2}{Number of subjects in the control group in
a randomization block. Defaults to 1 for equal randomization.}

\item{accrualTime}{Accrual time intervals, must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities, one for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for
the piecewise exponential survival distribution, must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{rho}{The correlation coefficient for the standard bivariate normal
random variables used to generate time to disease progression and time 
to death using the inverse CDF method.}

\item{lambda1e1}{A vector of hazard rates for the event in each analysis
time interval by stratum for the treatment group and endpoint 1 (PFS).}

\item{lambda2e1}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group and endpoint 1 (PFS).}

\item{lambda1e2}{A vector of hazard rates for the event in each analysis
time interval by stratum for the treatment group and endpoint 2 (OS).}

\item{lambda2e2}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group and endpoint 2 (OS).}

\item{gamma1e1}{The hazard rate for exponential dropout, a vector of 
hazard rates for piecewise exponential dropout applicable for all 
strata, or a vector of hazard rates for dropout in each analysis time 
interval by stratum for the treatment group and endpoint 1 (PFS).}

\item{gamma2e1}{The hazard rate for exponential dropout, a vector of 
hazard rates for piecewise exponential dropout applicable for all 
strata, or a vector of hazard rates for dropout in each analysis time 
interval by stratum for the control group and endpoint 1 (PFS).}

\item{gamma1e2}{The hazard rate for exponential dropout, a vector of 
hazard rates for piecewise exponential dropout applicable for all 
strata, or a vector of hazard rates for dropout in each analysis time 
interval by stratum for the treatment group and endpoint 2 (OS).}

\item{gamma2e2}{The hazard rate for exponential dropout, a vector of 
hazard rates for piecewise exponential dropout applicable for all 
strata, or a vector of hazard rates for dropout in each analysis time 
interval by stratum for the control group and endpoint 2 (OS).}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{rho1}{First parameter of the Fleming-Harrington family of weighted
log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{Second parameter of the Fleming-Harrington family of weighted
log-rank test. Defaults to 0 for conventional log-rank test.}

\item{plannedEvents}{The planned cumulative total number of PFS events at 
Look 1 to Look kMaxe1 and the planned cumulative total number of OS 
events at Look kMaxe1+1 to Look kMax.}

\item{plannedTime}{The planned analysis time for each stage needed for
analyses planned at calendar times, in which case, \code{plannedEvents} 
should be missing.}

\item{maxNumberOfIterations}{The number of simulation iterations.
Defaults to 1000.}

\item{maxNumberOfRawDatasetsPerStage}{The number of raw datasets per stage
to extract. Defaults to 1.}

\item{seed}{The seed to reproduce the simulation results.
The computer clock will be used if left unspecified,}
}
\value{
A list with 2 components:

* \code{sumdata} is a data frame of summary data by stage for each
iteration, containing the analysis time, number of accrued subjects 
overall and by treatment group, and number of events overall and 
by treatment group, number of dropouts overall and by treatment group, 
and log-rank test statistic by endpoint.

* \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
positive integer) is a data frame for subject-level data for selected
replications, containing the stage number, subject number, arrival time, 
stratum, treatment group, observation time, and survival time, 
dropout time, time under observation, event and dropout indicators 
for each endpoint.
}
\description{
Performs simulation for two-endpoint two-arm group 
sequential trials based on weighted log-rank test. The first \code{kMaxe1} 
looks are driven by the total number of PFS events in two arms 
combined, and the subsequent looks are driven by the total 
number of OS events in two arms combined.
}
\examples{

sim1 = lrsim2e(
  kMax = 3, 
  kMaxe1 = 2,
  allocation1 = 2, 
  allocation2 = 1, 
  accrualTime = c(0, 8), 
  accrualIntensity = c(10, 28),
  piecewiseSurvivalTime = 0, 
  rho = 0,
  lambda1e1 = log(2)/12*0.60,
  lambda2e1 = log(2)/12,
  lambda1e2 = log(2)/30*0.65, 
  lambda2e2 = log(2)/30,
  accrualDuration = 20.143,
  plannedEvents = c(186, 259, 183),
  maxNumberOfIterations = 1000,
  maxNumberOfRawDatasetsPerStage = 1,
  seed = 314159)
 
head(sim1$sumdata)
head(sim1$rawdata)

}
