% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{powerRiskDiffExact}
\alias{powerRiskDiffExact}
\title{Power for Exact Unconditional Test of Risk Difference}
\usage{
powerRiskDiffExact(
  n = NA_integer_,
  riskDiffH0 = 0,
  pi1 = NA_real_,
  pi2 = NA_real_,
  allocationRatioPlanned = 1,
  alpha = 0.025,
  calculateAttainedAlpha = 1L
)
}
\arguments{
\item{n}{The total sample size.}

\item{riskDiffH0}{The risk difference under the null hypothesis.
Defaults to 0.}

\item{pi1}{The assumed probability for the active treatment group.}

\item{pi2}{The assumed probability for the control group.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{alpha}{The one-sided significance level. Defaults to 0.025.}

\item{calculateAttainedAlpha}{Whether to calculate the attained alpha.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{alpha}: The specified one-sided significance level.
\item \code{attainedAlpha}: The attained one-sided significance level if
requested.
\item \code{power}: The power.
\item \code{n}: The sample size.
\item \code{riskDiffH0}: The risk difference under the null hypothesis.
\item \code{pi1}: The assumed probability for the active treatment group.
\item \code{pi2}: The assumed probability for the control group.
\item \code{allocationRatioPlanned}: Allocation ratio for the active
treatment versus control.
\item \code{zstatRiskDiffBound}: The critical value on the scale of
score test statistic for risk difference.
\item \code{pi2star}: The response probability in the control group
at which the critical value of the test statistic is attained.
}
}
\description{
Obtains the power given sample size for exact unconditional
test of risk difference.
}
\examples{

powerRiskDiffExact(n = 68, pi1 = 0.6, pi2 = 0.25, alpha = 0.05)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
