% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignMeans.R
\name{getDesignRepeatedANOVAContrast}
\alias{getDesignRepeatedANOVAContrast}
\title{Power and sample size for one-way repeated measures ANOVA contrast}
\usage{
getDesignRepeatedANOVAContrast(
  beta = NA_real_,
  n = NA_real_,
  ngroups = 2,
  means = NA_real_,
  stDev = 1,
  corr = 0,
  contrast = NA_real_,
  meanContrastH0 = 0,
  rounding = TRUE,
  alpha = 0.025
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{ngroups}{The number of treatment groups.}

\item{means}{The treatment group means.}

\item{stDev}{The total standard deviation.}

\item{corr}{The correlation among the repeated measures.}

\item{contrast}{The coefficients for the single contrast.}

\item{meanContrastH0}{The mean of the contrast under the
null hypothesis.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{alpha}{The one-sided significance level. Defaults to 0.025.}
}
\value{
An S3 class \code{designRepeatedANOVAContrast} object with
the following components:
\itemize{
\item \code{power}: The power to reject the null hypothesis for the
treatment contrast.
\item \code{alpha}: The one-sided significance level.
\item \code{n}: The number of subjects.
\item \code{ngroups}: The number of treatment groups.
\item \code{means}: The treatment group means.
\item \code{stDev}: The total standard deviation.
\item \code{corr}: The correlation among the repeated measures.
\item \code{contrast}: The coefficients for the single contrast.
\item \code{meanContrastH0}: The mean of the contrast under the null
hypothesis.
\item \code{meanContrast}: The mean of the contrast under the alternative
hypothesis.
\item \code{effectsize}: The effect size.
\item \code{rounding}: Whether to round up sample size.
}
}
\description{
Obtains the power and sample size for a single contrast
in one-way repeated measures analysis of variance.
}
\examples{

(design1 <- getDesignRepeatedANOVAContrast(
  beta = 0.1, ngroups = 4, means = c(1.5, 2.5, 2, 0),
  stDev = 5, corr = 0.2, contrast = c(1, 1, 1, -3)/3,
  alpha = 0.025))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
