% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_gen.R
\name{beta_gen}
\alias{beta_gen}
\title{Generate regression coefficients}
\usage{
beta_gen(
  data,
  MC = FALSE,
  MC_replications = 100,
  CI = c(0.005, 0.995),
  output_cov = FALSE,
  rename_to_q = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data}{output from the \code{questionnaire_gen} function with
\code{full_output = TRUE} and \code{theta = TRUE}}

\item{MC}{if \code{TRUE}, performs Monte Carlo simulation to estimate
regression coefficients}

\item{MC_replications}{for \code{MC = TRUE}, this represents the number of
Monte Carlo subsamples calculated}

\item{CI}{confidence interval for Monte Carlo simulations}

\item{output_cov}{if \code{TRUE}, will also output the covariance matrix of
YXW}

\item{rename_to_q}{if \code{TRUE}, renames the variables from "x" and "w" to
"q"}

\item{verbose}{if `FALSE`, output messages will be suppressed (useful for simulations). Defaults to `TRUE`}
}
\value{
By default, this function will output a vector of the regression
  coefficients, including intercept. If \code{MC == TRUE}, the output will
  instead be a matrix comparing the true regression coefficients obtained
  from the covariance matrix with expected values obtained from a Monte Carlo
  simulation, complete with 99\% confidence interval.

  If \code{output_cov = TRUE}, the output will be a list with two elements:
  the first one, \code{betas}, will contain the same output described in the
  previous paragraph. The second one, called \code{vcov_YXW}, contains
  the covariance matrix of the regression coefficients.
}
\description{
Uses the output from questionnaire_gen to generate linear
  regression coefficients.
}
\details{
This function was primarily conceived as a subfunction of
  \code{questionnaire_gen}, when \code{family = "gaussian"}, \code{theta =
  TRUE}, and \code{full_output = TRUE}. However, it can also be directly
  called by the user so they can perform further analysis.

  The regression coefficients are calculated using the true covariance matrix
  either provided by the user upon calling of \code{questionnaire_gen} or
  randomly generated by that function if none was provided. In any case, that
  matrix is not sample-dependent, though it should be similar to the one
  observed in the generated data (especially for larger samples). One
  convenient way to check for this similarity is by running the function with
  \code{MC = TRUE}, which will generate a numeric estimate; the
  \code{MC_replications} argument can be then increased to improve the
  estimates at a often-noticeable cost in processing time. If \code{MC =
  FALSE}, the \code{MC_replications} will have no effect on the results. In
  any case, each subsample will always have the same size as the original
  sample.

  If the background questionnaire contains categorical variables (\eqn{W}),
  the original covariance matrix cannot be used because it contains the
  covariances involving \eqn{Z ~ N(0, 1)}, which is the random variable that
  gets categorized into \eqn{W}. The case where \eqn{W} is always binomial is
  trivial, but if at least one \eqn{W} has more than two categories, the
  structure of the covariance matrix changes drastically. In this case, this
  function recalculates all covariances between \eqn{\theta}, \eqn{X} and
  each category of \eqn{W} using some auxiliary internal functions which rely
  on the appropriate distribution (either multivariate normal or truncated
  normal). To avoid multicollinearity, the first categories of each \eqn{W}
  are dropped before the regression coefficients are calculated.
}
\examples{

data <- questionnaire_gen(100, family="gaussian", theta = TRUE,
                           full_output = TRUE, n_X = 2, n_W = list(2, 2, 4))
beta_gen(data, MC = TRUE)

}
\seealso{
questionnaire_gen
}
