% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.lsm.R
\encoding{UTF-8}
\name{predict.lsm}
\alias{predict.lsm}
\title{Predictions and Confidence intervals}
\usage{
\method{predict}{lsm}(
  object,
  newdata,
  type = c("link", "response", "odd", "OR"),
  level = 0.95,
  ...
)
}
\arguments{
\item{object}{A fitted object of class \code{lsm}.}

\item{newdata}{Optionally, a data frame in which to look for variables with which to predict.}

\item{type}{The type of prediction required. The alternatives \code{response}, \code{link}, \code{odd} and \code{OR} give the predicted probabilities, logits, odds  and odds ratios, repectively.}

\item{level}{Confidence level to use (default is 0.95).}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The option \code{type =...} returns a matrix with one column containing the requested predictions. The option \code{interval =...} returns a matrix with 3 columns containing the lower and upper extremes of the requested interval and the corresponding predictions.
}
\description{
Obtains predictions  and confidence intervals from a fitted \code{lsm} object.
}
\details{
Predict Method for lsm Fits

If \code{newdata} is omitted, a matrix with the predictions for each observation is obtained. That is to say, the predictions are based on the data used for the fit. In that case how cases with missing values in the original fit is determined by the na.action argument of that fit. If na.action = na.omit omitted cases will not appear in the residuals, whereas if na.action = na.exclude they will appear (in predictions and standard errors), with residual value NA.

The saturated model is characterized by the assumptions 1 and 2 presented in section 2.3 by Llinas (2006, ISSN:2389-8976).
}
\examples{
#library(lsm)

#1. AGE and Coronary Heart Disease (CHD) Status of 20 subjects:

# library(lsm)
# library(tidyverse)
# datos <- lsm::chdage
# attach(datos)
# modelo <- lsm(CHD ~ AGE, data=datos)
# head(predict(modelo, type = "link"))
# predict(modelo,newdata=data.frame(AGE=35),type = "response")
# head(predict(modelo, type = "odd"))
# head(predict(modelo, type = "OR"))

}
\references{
[1] LLinás, H. J. (2006). Precisiones en la teoría de los modelos logísticos. Revista Colombiana de Estadística, 29(2), 239–265. https://revistas.unal.edu.co/index.php/estad/article/view/29310

[2] Hosmer, D.W., Lemeshow, S. and Sturdivant, R.X. (2013). Applied Logistic Regression, 3rd ed., New York: Wiley.

[3] Chambers, J. M. and Hastie, T. J. (1992). Statistical Models in S. Wadsworth & Brooks/Cole.
}
\author{
Dr. rer. nat. Humberto LLinás Solano [aut] (Universidad del Norte, Barranquilla-Colombia);  MSc. Omar Fábregas Cera [aut] (Universidad del Norte, Barranquilla-Colombia); MSc. Jorge Villalba Acevedo [cre, aut] (Universidad Tecnológica de Bolívar, Cartagena-Colombia).
}
