% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/durations.r
\name{duration}
\alias{duration}
\alias{is.duration}
\title{Create a duration object.}
\usage{
duration(num = NULL, units = "seconds", ...)

is.duration(x)
}
\arguments{
\item{num}{the number of time units to include in the duration}

\item{units}{a character string that specifies the type of units that num
refers to.}

\item{...}{a list of time units to be included in the duration and their
amounts. Seconds, minutes, hours, days, and weeks are supported.}

\item{x}{an R object}
}
\value{
a duration object
}
\description{
\code{duration} creates a duration object with the specified values. Entries
for different units are cumulative. durations display as the number of
seconds in a time span. When this number is large, durations also display an
estimate in larger units,; however, the underlying object is always recorded
as a fixed number of seconds. For display and creation purposes, units are
converted to seconds using their most common lengths in seconds. Minutes = 60
seconds, hours = 3600 seconds, days = 86400 seconds, weeks = 604800. Units
larger than weeks are not used due to their variability.
}
\details{
Durations record the exact number of seconds in a time span. They measure the
exact passage of time but do not always align with measurements
made in larger units of time such as hours, months and years.
This is because the length of larger time units can be affected
by conventions such as leap years
and Daylight Savings Time. Base R provides a second class for measuring
durations, the difftime class.

Duration objects can be easily created with the helper functions
\code{\link{dweeks}}, \code{\link{ddays}}, \code{\link{dminutes}},
\code{\link{dseconds}}. These objects can be added to and subtracted to date-
times to create a user interface similar to object oriented programming.
}
\examples{
duration(day = -1)
# -86400s (~-1 days)
duration(90, "seconds")
# 90s
duration(1.5, "minutes")
# 90s
duration(-1, "days")
# -86400s (~-1 days)
duration(second = 90)
# 90s
duration(minute = 1.5)
# 90s
duration(mins = 1.5)
# 90s
duration(second = 3, minute = 1.5, hour = 2, day = 6, week = 1)
# 1130493s (~13.08 days)
duration(hour = 1, minute = -60)
# 0s
is.duration(as.Date("2009-08-03")) # FALSE
is.duration(duration(days = 12.4)) # TRUE
}
\seealso{
\code{\link{as.duration}}
}
\keyword{chron}
\keyword{classes}

