% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors-tz.r
\name{tz}
\alias{tz}
\alias{tz<-}
\title{Get/set time zone component of a date-time}
\usage{
tz(x)

tz(x) <- value
}
\arguments{
\item{x}{A date-time vector, usually of class POSIXct or POSIXlt.}

\item{value}{New value of time zone.}
}
\value{
A character vector of length 1, giving the time zone of the vector.
An empty string (\code{""}) represents the current/default timezone.

For backward compatibility, the time zone of a date, \code{NA}, or
character vector is \code{"UTC"}.
}
\description{
Conveniently get and set the time zone of date-time, automatically
converting dates to date-times as needed.

Note that \verb{tz<-} is an alias for \code{\link[=force_tz]{force_tz()}}, which preserves the
local time, creating a different instant in time. Use \code{\link[=with_tz]{with_tz()}} if you
want keep the instant the same, but change the printed representation.
}
\section{Valid time zones}{

Time zones are stored in system specific database, so are not guaranteed
to be the same on every system (however, they are usually pretty similar
unless your sytsem is very out of date). You can see a complete list with
\code{\link[=OlsonNames]{OlsonNames()}}
}

\examples{
x <- ymd("2012-03-26", tz = "UTC")
tz(x)

tz(x) <- "GMT"
x
}
\seealso{
See \link{DateTimeClasses} for a description of the underlying
\code{tzone} attribute..
}
\keyword{chron}
\keyword{manip}
\keyword{methods}
\keyword{utilities}
