% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_combine.R
\name{test_combine}
\alias{test_combine}
\title{Association testing by combining several matching thresholds}
\usage{
test_combine(match_prob, y, x, thresholds = seq(from = 0.5, to = 0.95, by
  = 0.05), nb_perturb = 200, dist_family = c("gaussian", "binomial"),
  impute_strategy = c("weighted average", "best"))
}
\arguments{
\item{match_prob}{matching probabilities matrix (e.g. obtained through \code{\link{recordLink}}) of 
dimensions \code{n1 x n2}.}

\item{y}{response variable of length \code{n1}. Only binary phenotypes are supported at the moment.}

\item{x}{a \code{matrix} or a \code{data.frame} of predictors of dimensions \code{n2 x p}. 
An intercept is automatically within the function.}

\item{thresholds}{a vector (possibly of length \code{1}) containing the different threshold 
to use to call a match. Default is \code{seq(from = 0.5, to = 0.95, by = 0.05)}.}

\item{nb_perturb}{the number of perturbation used for the p-value combination.
Default is 200.}

\item{dist_family}{a character string indicating the distribution family for the glm. 
Currently, only \code{'gaussian'} and  \code{'binomial'} are supported. Default 
is \code{'gaussian'}.}

\item{impute_strategy}{a character string indicating which strategy to use to impute x 
from the matching probabilities \code{match_prob}. Either \code{"best"} (in which 
case the highest probable match above the threshold is imputed) or \code{"weighted average"}
(in which case weighted mean is imputed for each individual who has at least
one match with a posterior probability above the threshold). Default is 
\code{"weighted average"}.}
}
\value{
a list containing the following:
\itemize{
  \item \code{influencefn_pvals} p-values obtained from influence function perturbations
  with the covariates as columns and the \code{thresholds} as rows, with an additional row 
  at the top for the combination 
  \item \code{wald_pvals} a matrix containing the p-values obtained from the Wald 
  test with the covariates as columns and the \code{thresholds} as rows
  \item \code{ptbed_pvals} a list containing, for each covariates, a matrix with
  the \code{nb_perturb} perturbed p-values with the different \code{thresholds}
  as rows
  \item \code{theta_impute} a matrix of the estimated coefficients from the glm when imputing 
  the weighted average for covariates (as columns) with the \code{thresholds} as rows
  \item \code{sd_theta} a matrix of the estimated SD (from the influence function) of the 
  coefficients from the glm when imputing the weighted average for covariates (as columns),
  with the \code{thresholds} as rows
  \item \code{ptbed_theta_impute} a list containing, for each covariates, a matrix with
  the \code{nb_perturb} perturbed estimated coefficients from the glm when imputing 
  the weighted average for covariates, with the different \code{thresholds}
  as rows
  \item \code{impute_strategy} a character string indicating which impute 
  strategy was used (either \code{"weighted average"} or \code{"best"})
}
}
\description{
Computes association test p-values from a generalized linear model for each considered 
threshold, and computes a p-value for the combination of all the envisioned thresholds 
through Fisher's method using perturbation resampling.
}
\examples{
#rm(list=ls())
res <- list()
n_sims <- 1#5000
for(n in 1:n_sims){
x <- matrix(ncol=2, nrow=99, stats::rnorm(n=99*2))

#plot(density(rbeta(n=1000, 1,2)))
match_prob <- matrix(rbeta(n=103*99, 1, 2), nrow=103, ncol=99)


#y <- rnorm(n=103, 1, 0.5)
#res[[n]] <- test_combine(match_prob, y, x, dist_family="gaussian")$influencefn_pvals
y <- rbinom(n=103, 1, prob=0.5)
res[[n]] <- test_combine(match_prob, y, x, dist_family="binomial")$influencefn_pvals
cat(n, "/", n_sims, "\\n", sep="")
}
size <- matrix(NA, ncol=nrow(res[[1]]), nrow=ncol(res[[1]])-2)
colnames(size) <- rownames(res[[1]])
rownames(size) <- colnames(res[[1]])[-(-1:0 + ncol(res[[1]]))]
for(i in 1:(ncol(res[[1]])-2)){
 size[i, ] <- rowMeans(sapply(res, function(m){m[, i]<0.05}), na.rm = TRUE)
}
size

}
