% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple.R
\docType{class}
\name{simple}
\alias{simple}
\title{The simple logger}
\format{An \code{R6} class object.}
\usage{
simple
}
\description{
Record for each expression a \code{POSIXct} timestamp and a logical
indicating whether the tracked object has changed.
}
\section{Creating a logger}{


\code{simple$new(verbose=TRUE)}
\tabular{ll}{
  \code{verbose}\tab toggle verbosity
}
}

\section{Dump options}{
 

\code{$dump(file=NULL,...)}
\tabular{ll}{
\code{file}\tab filename or \code{\link[base]{connection}} to write output to.\cr
\code{...}\tab extra options passed to \code{\link[utils]{write.csv}}, except
\code{row.names}, which is set to \code{FALSE}.\cr
}

The default location is \code{"simple.csv"} in an interactive session, and
\code{"DATA_simple.csv"} in a script that executed via \code{\link{run_file}}.
Here, \code{DATA} is the variable name of the data being tracked 
or the \code{label} provided with \code{\link{start_log}}.
}

\section{Get data}{

\code{$logdata()} Returns a data frame with the current log.
}

\examples{

logfile <- tempfile(fileext=".csv")
out <- women \%L>\%
  start_log(log=simple$new(verbose=FALSE)) \%L>\%
  identity() \%L>\%
  head() \%L>\% 
  dump_log(file=logfile, stop=TRUE)


read.csv(logfile,stringsAsFactors=FALSE)

}
\seealso{
Other loggers: \code{\link{cellwise}},
  \code{\link{expression_logger}}, \code{\link{filedump}}
}
\concept{loggers}
\keyword{datasets}
