% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.r
\docType{methods}
\name{reshapes}
\alias{aperm}
\alias{aperm.madness}
\alias{dim<-,madness,ANY-method}
\alias{dim<-,madness-method}
\alias{reshapes}
\alias{t}
\alias{t,madness-method}
\alias{tril}
\alias{tril,madness-method}
\alias{triu}
\alias{triu,madness-method}
\title{Basic Reshape Operations}
\usage{
t(x)

\S4method{t}{madness}(x)

tril(x, k = 0, ...)

\S4method{tril}{madness}(x, k = 0)

triu(x, k = 0, ...)

\S4method{triu}{madness}(x, k = 0)

\S4method{dim}{madness}(x) <- value

aperm(a, perm=NULL, resize=TRUE, ...)
}
\arguments{
\item{x}{\code{madness} object.}

\item{k}{the index of the diagonal number from which to extract.\code{madness} object.}

\item{...}{Optional arguments used by specific methods. (None used at present.)}

\item{value}{an array of the new dimensions of the object value.}

\item{a}{the array to be transposed.}

\item{perm}{the subscript permutation vector, usually a permutation of
    the integers \code{1:n}, where \code{n} is the number of dimensions
    of \code{a}.  When \code{a} has named dimnames, it can be a
    character vector of length \code{n} giving a permutation of those
    names. The default (used whenever \code{perm} has zero length) is to
    reverse the order of the dimensions.}

\item{resize}{a flag indicating whether the vector should be
    resized as well as having its elements reordered (default \code{TRUE}).}
}
\description{
Basic Reshape Operations
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\seealso{
\code{\link{vec}}, \code{\link{todiag}}
}

