% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolstartmessage.R
\name{toolstartmessage}
\alias{toolstartmessage}
\title{Tool: Start message}
\usage{
toolstartmessage(argumentValues, level = NULL)
}
\arguments{
\item{argumentValues}{list of the evaluated arguments of the calling function}

\item{level}{This argument allows to establish a hierarchy of print
statements. The hierarchy is preserved for the next vcat executions.
Currently this setting can have 4 states: NULL (nothing will be changed), 0
(reset hierarchies), "+" (increase hierarchy level by 1) and "-" (decrease
hierarchy level by 1).}
}
\value{
a list containing diagnostic information required by \code{\link{toolendmessage}}
}
\description{
Function writes a process start message and performs some diagnostics
}
\examples{

innerFunction <- function() {
  startinfo <- madrat:::toolstartmessage(list(argumentsToPrint = 123), "+")
  vcat(1, "inner")
  madrat:::toolendmessage(startinfo, "-")
}
outerFunction <- function() {
  startinfo <- madrat:::toolstartmessage(list(), "+")
  vcat(1, "outer")
  innerFunction()
  madrat:::toolendmessage(startinfo, "-")
}
outerFunction()
}
\seealso{
\code{\link{toolendmessage}}, \code{\link{vcat}}
}
\author{
Jan Philipp Dietrich, Pascal Führlich
}
