% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{setDiscretization}
\alias{setDiscretization}
\title{Set discretization level}
\usage{
setDiscretization(dat, level, by)
}
\arguments{
\item{dat}{data matrix. Must include a column with name `time`.}

\item{level}{discretization level (a positive integer). \code{2^level - 1} equally-spaced time points will be inserted between each row of \code{dat}.}

\item{by}{discretization interval. As an alternative to \code{level}, time points will be inserted (as needed) to form an equally-spaced discretization set from the first to last observations of \code{dat}, with interval \code{by} between successive discretization points. This can be useful when the time points in \code{dat} are unevenly spaced.}
}
\value{
Returns a data matrix with the same columns as \code{dat}, with rows added for the inserted discretization time points.
}
\description{
Set the discretization level of a data matrix for input to \code{\link{MagiSolver}}, by inserting time points where the GP is constrained to the derivatives of the ODE system.
}
\details{
Specify the desired discretization using \code{level} or \code{by}.
}
\examples{
dat <- data.frame(time = 0:10, x = rnorm(11))
setDiscretization(dat, level = 2)
setDiscretization(dat, by = 0.2)

}
