% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary-helper.R
\name{get_pseudo_ipd_binary}
\alias{get_pseudo_ipd_binary}
\title{Create pseudo IPD given aggregated binary data}
\usage{
get_pseudo_ipd_binary(binary_agd, format = c("stacked", "unstacked"))
}
\arguments{
\item{binary_agd}{a data.frame that take different formats depending on \code{format}}

\item{format}{a string, "stacked" or "unstacked"}
}
\value{
a data.frame of pseudo binary IPD, with columns USUBJID, ARM, RESPONSE
}
\description{
Create pseudo IPD given aggregated binary data
}
\examples{
# example of unstacked
testdat <- data.frame(Yes = 280, No = 120)
rownames(testdat) <- "B"
get_pseudo_ipd_binary(
  binary_agd = testdat,
  format = "unstacked"
)

# example of stacked
get_pseudo_ipd_binary(
  binary_agd = data.frame(
    ARM = rep("B", 2),
    RESPONSE = c("YES", "NO"),
    COUNT = c(280, 120)
  ),
  format = "stacked"
)
}
