% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_km2.R
\name{basic_kmplot2}
\alias{basic_kmplot2}
\title{Basic Kaplan Meier (KM) plot function using ggplot}
\usage{
basic_kmplot2(
  kmlist,
  kmlist_name,
  endpoint_name = "Time to Event Endpoint",
  show_risk_set = TRUE,
  main_title = "Kaplan-Meier Curves",
  break_x_by = NULL,
  censor = TRUE,
  xlab = "Time",
  xlim = NULL,
  use_colors = NULL,
  use_line_types = NULL
)
}
\arguments{
\item{kmlist}{a list of \code{survfit} object}

\item{kmlist_name}{a vector indicating the treatment names of each \code{survfit} object}

\item{endpoint_name}{a string, name of time to event endpoint, to be show in the
last line of title}

\item{show_risk_set}{logical, show risk set table or not, TRUE by default}

\item{main_title}{a string, main title of the KM plot}

\item{break_x_by}{bin parameter for \code{survminer}}

\item{censor}{indicator to include censor information}

\item{xlab}{label name for x-axis of the plot}

\item{xlim}{x limit for the x-axis of the plot}

\item{use_colors}{a character vector of length up to 4, colors to the KM curves,
it will be passed to 'col' of \code{lines()}}

\item{use_line_types}{a numeric vector of length up to 4, line type to the KM curves,
it will be passed to \code{lty} of \code{lines()}}
}
\value{
A Kaplan-Meier plot object created with \code{survminer::ggsurvplot()}.
}
\description{
This function generates a basic KM plot using ggplot.
}
\examples{
library(survival)
data(adtte_sat)
data(pseudo_ipd_sat)

kmobj_A <- survfit(Surv(TIME, EVENT) ~ ARM,
  data = adtte_sat,
  conf.type = "log-log"
)

kmobj_B <- survfit(Surv(TIME, EVENT) ~ ARM,
  data = pseudo_ipd_sat,
  conf.type = "log-log"
)

kmlist <- list(kmobj_A = kmobj_A, kmobj_B = kmobj_B)
kmlist_name <- c("A", "B")

basic_kmplot2(kmlist, kmlist_name)
}
