# WARNING - Generated by {fusen} from dev/import-data.Rmd: do not edit by hand

#' Importing spectra from the Bruker MALDI Biotyper device
#'
#' This function is a wrapper around the [readBrukerFlexData::readBrukerFlexDir()] to read both `acqus` and `acqu` MALDI files.
#'
#'
#' @details When using [readBrukerFlexData::readBrukerFlexDir()] on `acqus` files (instead of the native `acqu` files), the function will fail with the following error message:
#'
#' ```
#' Error in .readAcquFile(fidFile = fidFile, verbose = verbose) :
#' File ‘/data/maldi_dir/targetA/0_D10/1/1SLin/acqu’ doesn't exists!
#' ```
#'
#' But it turns out that `acqu` and `acqus` files [are the same](https://github.com/sgibb/readBrukerFlexData/wiki/acqu-file), so the function here create `acqu` symbolic links that point to `acqus` files.
#'
#' @param biotyper_directory A path to the folder tree with the spectra to be imported.
#' @param remove_calibration A vector of characters used as regex to indicate which (calibration) spectra are going to be removed.
#'
#' @return A list of [MALDIquant::MassSpectrum] objects
#'
#' @seealso [check_spectra], [process_spectra]
#'
#' @export
#' @examples
#' # Get an example directory of six Bruker MALDI Biotyper spectra
#' directory_biotyper_spectra <- system.file(
#'   "toy-species-spectra",
#'   package = "maldipickr"
#' )
#' # Import the six spectra
#' spectra_list <- import_biotyper_spectra(directory_biotyper_spectra)
#' # Display the list of spectra
#' spectra_list
import_biotyper_spectra <- function(biotyper_directory, remove_calibration = c("BTS", "Autocalibration")) {
  # List all the acqus files
  acqus_files <- list.files(
    biotyper_directory,
    pattern = "acqus$",
    recursive = TRUE, full.names = TRUE
  )
  # Prepare the absolute filename for acqu
  acqu_files <- gsub("acqus$", "acqu", acqus_files)
  # Acqu files as symbolic links if they do not exist
  do_symbolic_links <- !file.exists(acqu_files)
  if (any(do_symbolic_links)) {
    links_status <- file.symlink(
      from = acqus_files[do_symbolic_links],
      to = acqu_files[do_symbolic_links]
    )
  }
  # MALDIquantForeign::importBrukerFlex depends on
  # readMzXmlData (>= 2.7) which itself needs R >= 4.2.0
  # but the import of BrukerFlex does not really needs
  # these dependency. Therefore, simplifying the import with
  # the readBrukerFlexData.
  biotyper_list <- readBrukerFlexData::readBrukerFlexDir(biotyper_directory)
  biotyper_list <- lapply(biotyper_list, function(raw) {
    MALDIquant::createMassSpectrum(
      mass = raw$spectrum$mass,
      intensity = raw$spectrum$intensity,
      metaData = raw$metaData
    )
  })
  biotyper_list <- unname(biotyper_list)
  # Catch the arguments of which spectrum to remove
  remove_calibration <- match.arg(remove_calibration, several.ok = T)
  if (length(remove_calibration) != 0) {
    # Regex to remove the chosen spectrum
    to_catch <- c(
      "BTS" = "BTS|BTS_Validation",
      "Autocalibration" = "Autocalibration"
    )
    regex_to_catch <- match.arg(remove_calibration, to_catch, several.ok = T) %>%
      paste(collapse = "|")
    to_remove <- vapply(biotyper_list,
                        function(x){grepl(regex_to_catch, MALDIquant::metaData(x)$file)},
                        FUN.VALUE = logical(1))
    biotyper_list <- biotyper_list[!to_remove]
  }
  # Clean up the symbolink links if any
  if (any(do_symbolic_links)) {
    file.remove(acqu_files[do_symbolic_links])
  }
  return(biotyper_list)
}
