/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.princeton.data;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.StringTokenizer;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.FileDictionaryElementFactory;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.SynsetProxy;
import net.didion.jwnl.data.Verb;
import net.didion.jwnl.data.Word;
import net.didion.jwnl.princeton.data.MutableVerb;
import net.didion.jwnl.util.MessageLog;
import net.didion.jwnl.util.MessageLogLevel;
import net.didion.jwnl.util.TokenizerParser;

public abstract class AbstractPrincetonFileDictionaryElementFactory
implements FileDictionaryElementFactory {
    private static final MessageLog _log = new MessageLog(class$net$didion$jwnl$princeton$data$AbstractPrincetonFileDictionaryElementFactory == null ? (class$net$didion$jwnl$princeton$data$AbstractPrincetonFileDictionaryElementFactory = AbstractPrincetonFileDictionaryElementFactory.class$("net.didion.jwnl.princeton.data.AbstractPrincetonFileDictionaryElementFactory")) : class$net$didion$jwnl$princeton$data$AbstractPrincetonFileDictionaryElementFactory);
    static /* synthetic */ Class class$net$didion$jwnl$princeton$data$AbstractPrincetonFileDictionaryElementFactory;

    protected AbstractPrincetonFileDictionaryElementFactory() {
    }

    public IndexWord createIndexWord(POS pos, String line) {
        TokenizerParser tokenizer = new TokenizerParser(line, " ");
        String lemma = tokenizer.nextToken().replace('_', ' ');
        tokenizer.nextToken();
        tokenizer.nextToken();
        int pointerCount = tokenizer.nextInt();
        for (int i = 0; i < pointerCount; ++i) {
            tokenizer.nextToken();
        }
        int senseCount = tokenizer.nextInt();
        tokenizer.nextInt();
        long[] synsetOffsets = new long[senseCount];
        for (int i = 0; i < senseCount; ++i) {
            synsetOffsets[i] = tokenizer.nextLong();
        }
        if (_log.isLevelEnabled(MessageLogLevel.TRACE)) {
            _log.log(MessageLogLevel.TRACE, "PRINCETON_INFO_003", new Object[]{lemma, pos});
        }
        return new IndexWord(lemma, pos, synsetOffsets);
    }

    public Synset createSynset(POS pos, String line) {
        TokenizerParser tokenizer = new TokenizerParser(line, " ");
        long offset = tokenizer.nextLong();
        tokenizer.nextToken();
        String synsetPOS = tokenizer.nextToken();
        boolean isAdjectiveCluster = false;
        if (synsetPOS.equals("s")) {
            isAdjectiveCluster = true;
        }
        SynsetProxy proxy = new SynsetProxy(pos);
        int wordCount = tokenizer.nextHexInt();
        Word[] words = new Word[wordCount];
        for (int i = 0; i < wordCount; ++i) {
            String lemma = tokenizer.nextToken();
            tokenizer.nextHexInt();
            words[i] = this.createWord(proxy, i, lemma);
        }
        int pointerCount = tokenizer.nextInt();
        Pointer[] pointers = new Pointer[pointerCount];
        for (int i = 0; i < pointerCount; ++i) {
            String pt = tokenizer.nextToken();
            PointerType pointerType = PointerType.getPointerTypeForKey(pt);
            long targetOffset = tokenizer.nextLong();
            POS targetPOS = POS.getPOSForKey(tokenizer.nextToken());
            int linkIndices = tokenizer.nextHexInt();
            int sourceIndex = linkIndices / 256;
            int targetIndex = linkIndices & 0xFF;
            SynsetProxy source = sourceIndex == 0 ? proxy : words[sourceIndex - 1];
            pointers[i] = new Pointer(source, i, pointerType, targetPOS, targetOffset, targetIndex);
        }
        if (pos == POS.VERB) {
            int verbFrameCount = tokenizer.nextInt();
            for (int i = 0; i < verbFrameCount; ++i) {
                tokenizer.nextToken();
                int frameNumber = tokenizer.nextInt();
                int wordIndex = tokenizer.nextHexInt();
                if (wordIndex > 0) {
                    ((MutableVerb)words[wordIndex - 1]).setVerbFrameFlag(frameNumber);
                    continue;
                }
                for (int j = 0; j < words.length; ++j) {
                    ((MutableVerb)words[j]).setVerbFrameFlag(frameNumber);
                }
            }
        }
        String gloss = null;
        int index = line.indexOf(124);
        if (index > 0) {
            gloss = line.substring(index + 2).trim();
        }
        BitSet verbFrames = new BitSet();
        for (int i = 0; i < words.length; ++i) {
            if (!(words[i] instanceof Verb)) continue;
            verbFrames.or(((Verb)words[i]).getVerbFrameFlags());
        }
        Synset synset = new Synset(pos, offset, words, pointers, gloss, verbFrames, isAdjectiveCluster);
        proxy.setSource(synset);
        if (_log.isLevelEnabled(MessageLogLevel.TRACE)) {
            _log.log(MessageLogLevel.TRACE, "PRINCETON_INFO_002", new Object[]{pos, new Long(offset)});
        }
        return proxy;
    }

    protected Word createWord(Synset synset, int index, String lemma) {
        if (synset.getPOS().equals(POS.VERB)) {
            return new MutableVerb(synset, index, lemma);
        }
        return new Word(synset, index, lemma);
    }

    public Exc createExc(POS pos, String line) {
        StringTokenizer st = new StringTokenizer(line);
        String lemma = st.nextToken().replace('_', ' ');
        ArrayList<String> exceptions = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            exceptions.add(st.nextToken().replace('_', ' '));
        }
        if (_log.isLevelEnabled(MessageLogLevel.TRACE)) {
            _log.log(MessageLogLevel.TRACE, "PRINCETON_INFO_001", new Object[]{pos, lemma});
        }
        return new Exc(pos, lemma, exceptions);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

