/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised;

import cc.mallet.types.Alphabet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class StateLabelMap {
    public static final int START_LABEL = -2;
    private Alphabet stateAlphabet;
    private Alphabet labelAlphabet;
    private boolean isOneToOneMap;
    private HashMap<Integer, Integer> stateToLabel;
    private HashMap<Integer, LinkedHashSet<Integer>> labelToState;

    public StateLabelMap(Alphabet labelAlphabet, boolean isOneToOneMap) {
        this(labelAlphabet, isOneToOneMap, -1);
    }

    public StateLabelMap(Alphabet labelAlphabet, boolean isOneToOneMap, int startStateIndex) {
        this.labelAlphabet = labelAlphabet;
        this.isOneToOneMap = isOneToOneMap;
        this.stateToLabel = new HashMap();
        this.labelToState = new HashMap();
        Iterator labelIter = null;
        if (isOneToOneMap) {
            this.stateAlphabet = labelAlphabet;
            labelIter = labelAlphabet.iterator();
            while (labelIter.hasNext()) {
                String label = (String)labelIter.next();
                int labelIndex = labelAlphabet.lookupIndex(label, false);
                this.stateToLabel.put(labelIndex, labelIndex);
                LinkedHashSet<Integer> stateIndices = new LinkedHashSet<Integer>();
                stateIndices.add(labelIndex);
                this.labelToState.put(labelIndex, stateIndices);
            }
        } else {
            this.stateAlphabet = new Alphabet();
            labelIter = labelAlphabet.iterator();
            while (labelIter.hasNext()) {
                String label = (String)labelIter.next();
                this.labelToState.put(labelAlphabet.lookupIndex(label, false), new LinkedHashSet());
            }
        }
        if (startStateIndex != -1) {
            this.addStartState(startStateIndex);
        }
    }

    public void addStartState(int index) {
        this.stateToLabel.put(index, -2);
    }

    public boolean isOneToOneMapping() {
        return this.isOneToOneMap;
    }

    public int getNumLabels() {
        return this.labelToState.size();
    }

    public int getNumStates() {
        return this.stateToLabel.size();
    }

    public Alphabet getLabelAlphabet() {
        return this.labelAlphabet;
    }

    public Alphabet getStateAlphabet() {
        return this.stateAlphabet;
    }

    public int getLabelIndex(int stateIndex) {
        Integer labelIndex = this.stateToLabel.get(stateIndex);
        if (labelIndex == null) {
            return -1;
        }
        return labelIndex;
    }

    public LinkedHashSet<Integer> getStateIndices(int labelIndex) {
        return this.labelToState.get(labelIndex);
    }

    public int addState(String stateName, String labelName) {
        if (this.isOneToOneMap) {
            throw new IllegalStateException("Trying to add a state when there is a one to one mapping between the states and labels.");
        }
        int labelIndex = this.labelAlphabet.lookupIndex(labelName, false);
        if (labelIndex == -1) {
            throw new IllegalArgumentException("Invalid label: " + labelName);
        }
        int stateIndex = this.stateAlphabet.lookupIndex(stateName, false);
        if (stateIndex != -1) {
            throw new IllegalArgumentException("Duplicate state: " + stateName);
        }
        stateIndex = this.stateAlphabet.lookupIndex(stateName, true);
        try {
            this.labelToState.get(labelIndex).add(stateIndex);
        }
        catch (NullPointerException npe) {
            LinkedHashSet<Integer> stateIndices = new LinkedHashSet<Integer>();
            stateIndices.add(stateIndex);
            this.labelToState.put(labelIndex, stateIndices);
        }
        this.stateToLabel.put(stateIndex, labelIndex);
        return stateIndex;
    }
}

