% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_indirect_effect_list.R
\name{total_indirect_effect}
\alias{total_indirect_effect}
\title{Total Indirect Effect Between
Two Variables}
\usage{
total_indirect_effect(object, x, y)
}
\arguments{
\item{object}{The output of
\code{\link[=many_indirect_effects]{many_indirect_effects()}}, or a list
of \code{indirect}-class objects.}

\item{x}{Character. The name of the \code{x} variable.
All paths start from \code{x} will be
included.}

\item{y}{Character. The name of the \code{y} variable.
All paths end at \code{y} will be included.}
}
\value{
An \code{indirect}-class
object.
}
\description{
Compute the total
indirect effect between two
variables in the paths estimated by
\code{\link[=many_indirect_effects]{many_indirect_effects()}}.
}
\details{
It extracts the
\code{indirect}-class objects
of relevant paths and then add
the indirect effects together
using the \code{+} operator.
}
\examples{

library(lavaan)
data(data_serial_parallel)
mod <-
"
m11 ~ x + c1 + c2
m12 ~ m11 + x + c1 + c2
m2 ~ x + c1 + c2
y ~ m12 + m2 + m11 + x + c1 + c2
"
fit <- sem(mod, data_serial_parallel,
           fixed.x = FALSE)

# All indirect paths, control variables excluded
paths <- all_indirect_paths(fit,
                            exclude = c("c1", "c2"))
paths

# Indirect effect estimates
out <- many_indirect_effects(paths,
                             fit = fit)
out

# Total indirect effect from x to y
total_indirect_effect(out,
                      x = "x",
                      y = "y")


}
\seealso{
\code{\link[=many_indirect_effects]{many_indirect_effects()}}
}
