% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_2_and_3.R
\docType{data}
\name{data_mod2}
\alias{data_mod2}
\title{Sample Dataset: Two Moderators}
\format{
A data frame with 100 rows
and 6 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{w1}{Moderator 1. Numeric.}
\item{w2}{Moderator 2. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_mod2
}
\description{
A two-moderator model.
}
\examples{
library(lavaan)
data(data_mod2)
data_mod2$xw1 <- data_mod2$x * data_mod2$w1
data_mod2$xw2 <- data_mod2$x * data_mod2$w2
mod <-
"
y ~ a * x + w1 + w2 + d1 * xw1 + d2 * xw2 + c1 + c2
w1 ~~ v_w1 * w1
w1 ~ m_w1 * 1
w2 ~~ v_w2 * w2
w2 ~ m_w2 * 1
a_lolo := a + d1 * (m_w1 - sqrt(v_w1)) + d2 * (m_w2 - sqrt(v_w2))
a_lohi := a + d1 * (m_w1 - sqrt(v_w1)) + d2 * (m_w2 + sqrt(v_w2))
a_hilo := a + d1 * (m_w1 + sqrt(v_w1)) + d2 * (m_w2 - sqrt(v_w2))
a_hihi := a + d1 * (m_w1 + sqrt(v_w1)) + d2 * (m_w2 + sqrt(v_w2))
"
fit <- sem(mod, data_mod2, fixed.x = FALSE)
parameterEstimates(fit)[c(1, 4, 5, 8:11, 34:37), ]
}
\keyword{datasets}
