% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/member_community.R
\name{member_community_non}
\alias{member_community_non}
\alias{node_in_optimal}
\alias{node_in_partition}
\alias{node_in_infomap}
\alias{node_in_spinglass}
\alias{node_in_fluid}
\alias{node_in_louvain}
\alias{node_in_leiden}
\title{Non-hierarchical community partitioning algorithms}
\usage{
node_in_optimal(.data)

node_in_partition(.data)

node_in_infomap(.data, times = 50)

node_in_spinglass(.data, max_k = 200, resolution = 1)

node_in_fluid(.data)

node_in_louvain(.data, resolution = 1)

node_in_leiden(.data, resolution = 1)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{times}{Integer indicating number of simulations/walks used.
By default, \code{times=50}.}

\item{max_k}{Integer constant, the number of spins to use as an upper limit
of communities to be found. Some sets can be empty at the end.}

\item{resolution}{The Reichardt-Bornholdt “gamma” resolution parameter for modularity.
By default 1, making existing and non-existing ties equally important.
Smaller values make existing ties more important,
and larger values make missing ties more important.}
}
\description{
These functions offer algorithms for partitioning
networks into sets of communities:
\itemize{
\item \code{node_in_optimal()} is a problem-solving algorithm that seeks to maximise
modularity over all possible partitions.
\item \code{node_in_partition()} is a greedy, iterative, deterministic
partitioning algorithm that results in two equally-sized communities.
\item \code{node_in_infomap()} is an algorithm based on the information in random walks.
\item \code{node_in_spinglass()} is a greedy, iterative, probabilistic algorithm,
based on analogy to model from statistical physics.
\item \code{node_in_fluid()} is a propogation-based partitioning algorithm,
based on analogy to model from fluid dynamics.
\item \code{node_in_louvain()} is an agglomerative multilevel algorithm that seeks to maximise
modularity over all possible partitions.
\item \code{node_in_leiden()} is an agglomerative multilevel algorithm that seeks to maximise
the Constant Potts Model over all possible partitions.
}

The different algorithms offer various advantages in terms of computation time,
availability on different types of networks, ability to maximise modularity,
and their logic or domain of inspiration.
}
\section{Optimal}{

The general idea is to calculate the modularity of all possible partitions,
and choose the community structure that maximises this modularity measure.
Note that this is an NP-complete problem with exponential time complexity.
The guidance in the igraph package is networks of <50-200 nodes is probably fine.
}

\section{Infomap}{

Motivated by information theoretic principles, this algorithm tries to build
a grouping that provides the shortest description length for a random walk,
where the description length is measured by the expected number of bits per node required to encode the path.
}

\section{Spin-glass}{

This is motivated by analogy to the Potts model in statistical physics.
Each node can be in one of \emph{k} "spin states",
and ties (particle interactions) provide information about which pairs of nodes
want similar or different spin states.
The final community definitions are represented by the nodes' spin states
after a number of updates.
A different implementation than the default is used in the case of signed networks,
such that nodes connected by negative ties will be more likely found in separate communities.
}

\section{Fluid}{

The general idea is to observe how a discrete number of fluids interact, expand and contract,
in a non-homogenous environment, i.e. the network structure.
Unlike the \code{{igraph}} implementation that this function wraps,
this function iterates over all possible numbers of communities and returns the membership
associated with the highest modularity.
}

\section{Louvain}{

The general idea is to take a hierarchical approach to optimising the modularity criterion.
Nodes begin in their own communities and are re-assigned in a local, greedy way:
each node is moved to the community where it achieves the highest contribution to modularity.
When no further modularity-increasing reassignments are possible,
the resulting communities are considered nodes (like a reduced graph),
and the process continues.
}

\section{Leiden}{

The general idea is to optimise the Constant Potts Model,
which does not suffer from the resolution limit, instead of modularity.
As outlined in the \code{{igraph}} package,
the Constant Potts Model object function is:

\deqn{\frac{1}{2m} \sum_{ij}(A_{ij}-\gamma n_i n_j)\delta(\sigma_i, \sigma_j)}

where \emph{m} is the total tie weight,
\eqn{A_{ij}} is the tie weight between \emph{i} and \emph{j},
\eqn{\gamma} is the so-called resolution parameter,
\eqn{n_i} is the node weight of node \emph{i},
and \eqn{\delta(\sigma_i, \sigma_j) = 1} if and only if
\emph{i} and \emph{j} are in the same communities and 0 otherwise.
}

\examples{
node_in_optimal(ison_adolescents)
node_in_partition(ison_adolescents)
node_in_partition(ison_southern_women)
node_in_infomap(ison_adolescents)
node_in_spinglass(ison_adolescents)
node_in_fluid(ison_adolescents)
node_in_louvain(ison_adolescents)
node_in_leiden(ison_adolescents)
}
\references{
\subsection{On optimal community detection}{

Brandes, Ulrik, Daniel Delling, Marco Gaertler, Robert Gorke, Martin Hoefer, Zoran Nikoloski, Dorothea Wagner. 2008.
"On Modularity Clustering",
\emph{IEEE Transactions on Knowledge and Data Engineering} 20(2):172-188.
}

\subsection{On partitioning community detection}{

Kernighan, Brian W., and Shen Lin. 1970.
"An efficient heuristic procedure for partitioning graphs."
\emph{The Bell System Technical Journal} 49(2): 291-307.
\doi{10.1002/j.1538-7305.1970.tb01770.x}
}

\subsection{On infomap community detection}{

Rosvall, M, and C. T. Bergstrom. 2008.
"Maps of information flow reveal community structure in complex networks",
\emph{PNAS} 105:1118.
\doi{10.1073/pnas.0706851105}

Rosvall, M., D. Axelsson, and C. T. Bergstrom. 2009.
"The map equation",
\emph{Eur. Phys. J. Special Topics} 178: 13.
\doi{10.1140/epjst/e2010-01179-1}
}

\subsection{On spinglass community detection}{

Reichardt, Jorg, and Stefan Bornholdt. 2006.
"Statistical Mechanics of Community Detection"
\emph{Physical Review E}, 74(1): 016110–14.
\doi{10.1073/pnas.0605965104}

Traag, Vincent A., and Jeroen Bruggeman. 2009.
"Community detection in networks with positive and negative links".
\emph{Physical Review E}, 80(3): 036115.
\doi{10.1103/PhysRevE.80.036115}
}

\subsection{On fluid community detection}{

Parés Ferran, Dario Garcia Gasulla, Armand Vilalta, Jonatan Moreno, Eduard Ayguade, Jesus Labarta, Ulises Cortes, and Toyotaro Suzumura. 2018.
"Fluid Communities: A Competitive, Scalable and Diverse Community Detection Algorithm".
In: \emph{Complex Networks & Their Applications VI}
Springer, 689: 229.
\doi{10.1007/978-3-319-72150-7_19}
}

\subsection{On Louvain community detection}{

Blondel, Vincent, Jean-Loup Guillaume, Renaud Lambiotte, Etienne Lefebvre. 2008.
"Fast unfolding of communities in large networks",
\emph{J. Stat. Mech.} P10008.
}

\subsection{On Leiden community detection}{

Traag, Vincent A., Ludo Waltman, and Nees Jan van Eck. 2019.
"From Louvain to Leiden: guaranteeing well-connected communities",
\emph{Scientific Reports}, 9(1):5233.
\doi{10.1038/s41598-019-41695-z}
}
}
\seealso{
Other memberships: 
\code{\link{mark_core}},
\code{\link{member_brokerage}},
\code{\link{member_cliques}},
\code{\link{member_community_hier}},
\code{\link{member_components}},
\code{\link{member_equivalence}}
}
\concept{memberships}
