% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LEiDA.R
\name{LEiDA}
\alias{LEiDA}
\title{Leading Eigenvector Dynamics Analysis}
\usage{
LEiDA(X, TR, bp = c(0.01, 0.1), b_ord = 2)
}
\arguments{
\item{X}{A \eqn{(T,N)} matrix of multivariate time series data, where \eqn{T} is the number of time points and \eqn{N} is the number of ROIs.}

\item{TR}{Repetition time (in secounds)}

\item{bp}{Bandpass filter, a vector of length 2 with the lower and upper bounds of the bandpass filter in Hz. Default is \code{c(0.01, 0.10)}.}

\item{b_ord}{Butterworth order, a positive integer. Default is 2.}
}
\value{
a list containing \describe{
\item{V}{A \eqn{(T,N)} matrix of the leading eigenvector time series.}
\item{FCD_cos}{A \eqn{(T,T)} matrix of the functional connectivity dynamics (FCD) using cosine similarity.}
\item{FCD_cor}{A \eqn{(T,T)} matrix of the functional connectivity dynamics (FCD) using Pearson correlation.}
}
}
\description{
Compute the leading eigenvector dynamics analysis (LEiDA) of a 
multivariate time series as appearing in computational neuroscience.
}
