% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_submap.R
\name{get_submap}
\alias{get_submap}
\title{Extract sub-map from map}
\usage{
get_submap(
  input.map,
  mrk.pos,
  phase.config = "best",
  reestimate.rf = TRUE,
  reestimate.phase = FALSE,
  thres.twopt = 5,
  thres.hmm = 3,
  extend.tail = 50,
  tol = 0.1,
  tol.final = 0.001,
  use.high.precision = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{input.map}{An object of class \code{mappoly.map}}

\item{mrk.pos}{positions of the markers that should be considered in the new map. 
This can be in any order}

\item{phase.config}{which phase configuration should be used. "best" (default) 
will choose the configuration associated with the maximum 
likelihood}

\item{reestimate.rf}{logical. If \code{TRUE} (default) the recombination fractions 
between markers are re-estimated}

\item{reestimate.phase}{logical. If \code{TRUE}, the linkage phase configurations are 
re-estimated (default = FALSE)}

\item{thres.twopt}{the LOD threshold used to determine if the linkage
phases compared via two-point analysis should be considered (default = 5)}

\item{thres.hmm}{the threshold used to determine if the linkage
phases compared via hmm analysis should be considered (default = 3)}

\item{extend.tail}{the length of the tail of the chain that should
be used to calculate the likelihood of the linkage phases. If
\code{info.tail = TRUE}, the function uses at least \code{extend.tail}
as the length of the tail (default = 50)}

\item{tol}{the desired accuracy during the sequential phase (default = 0.1)}

\item{tol.final}{the desired accuracy for the final map (default = 10e-04)}

\item{use.high.precision}{logical. If \code{TRUE} uses high precision 
(long double) numbers in the HMM procedure implemented in C++,
which can take a long time to perform (default = FALSE)}

\item{verbose}{If \code{TRUE} (default), current progress is shown; if
\code{FALSE}, no output is produced}
}
\description{
Given a pre-constructed map, it extracts a sub-map for a provided 
sequence of marker positions. Optionally, it can update the linkage phase
configurations and respective recombination fractions.
}
\examples{
 \donttest{
    ## selecting the six first markers in linkage group 1
    ## re-estimating the recombination fractions and linkage phases
    submap1.lg1<-get_submap(input.map = maps.hexafake[[1]], 
                           mrk.pos = 1:6, verbose = TRUE,
                           reestimate.phase = TRUE,  
                           tol.final = 10e-3)
   ## no recombination fraction re-estimation: first 20 markers
   submap2.lg1<-get_submap(input.map = maps.hexafake[[1]], 
                           mrk.pos = 1:20, reestimate.rf = FALSE,
                           verbose = TRUE, 
                           tol.final = 10e-3)
  plot(maps.hexafake[[1]])
  plot(submap1.lg1, mrk.names = TRUE, cex = .8)
  plot(submap2.lg1, mrk.names = TRUE, cex = .8)
  }

}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \url{https://doi.org/10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
