#' @Title SLU farm (Brogarden) soil sample data -topsoil clay content
#'
#' @usage data(CLAYs)
#'
#' @format SpatialPointsDataFrame. Projected coordinate system: Sweref99TM
#' (epsg: 3006). Attribute: Lab analyzed topsoil (0-20 cm depth)
#' clay content (% of fine soil).
#'
#' @keywords datasets
#'
#' @references Piikki, K., Wetterlind, J., Söderström, M., & Stenberg, B. (2015).
#' Three-dimensional digital soil mapping of agricultural fields by integration
#' of multiple proximal sensor data obtained from different sensing methods.
#' Precision agriculture, 16(1), 29-45. https://doi.org/10.1007/s11119-014-9381-6
#'
#' @example
#' data(CLAYs)
#' raster::plot(CLAYs)
#'
#'@export data(CLAYs)

